"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESQLDefaultLimitSizeSelect = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/index_data_visualizer/components/search_panel/esql/limit_size.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const options = [{
  'data-test-subj': 'dvESQLLimitSize-5000',
  value: '5000',
  text: _i18n.i18n.translate('xpack.dataVisualizer.searchPanel.esql.limitSizeOptionLabel', {
    defaultMessage: '{limit} rows',
    values: {
      limit: '5,000'
    }
  })
}, {
  'data-test-subj': 'dvESQLLimitSize-10000',
  value: '10000',
  text: _i18n.i18n.translate('xpack.dataVisualizer.searchPanel.esql.limitSizeOptionLabel', {
    defaultMessage: '{limit} rows',
    values: {
      limit: '10,000'
    }
  })
}];
const ESQLDefaultLimitSizeSelect = ({
  limitSize,
  onChangeLimitSize
}) => {
  const basicSelectId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'dvESQLLimit'
  });
  const onChange = e => {
    onChangeLimitSize(e.target.value);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "dvESQLLimitSizeSelect",
    id: basicSelectId,
    options: options,
    value: limitSize,
    onChange: onChange,
    "aria-label": _i18n.i18n.translate('xpack.dataVisualizer.searchPanel.esql.limitSizeAriaLabel', {
      defaultMessage: 'Limit size'
    }),
    prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      textAlign: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.searchPanel.esql.limitSizeLabel",
      defaultMessage: "Limit analysis to",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 11
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  });
};
exports.ESQLDefaultLimitSizeSelect = ESQLDefaultLimitSizeSelect;