"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runDocCountSearch = runDocCountSearch;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function runDocCountSearch(dataStart, index, timeField, earliestMs, latestMs, timeBuckets) {
  const intervalMs = timeBuckets.getInterval().asMilliseconds();
  const resp = await (0, _rxjs.lastValueFrom)(dataStart.search.search({
    params: {
      index,
      size: 0,
      query: {
        bool: {
          must: [{
            range: {
              [timeField]: {
                gte: earliestMs,
                lte: latestMs,
                format: 'epoch_millis'
              }
            }
          }, {
            match_all: {}
          }]
        }
      },
      aggs: {
        eventRate: {
          date_histogram: {
            field: timeField,
            fixed_interval: `${intervalMs}ms`,
            min_doc_count: 0,
            extended_bounds: {
              min: earliestMs,
              max: latestMs
            }
          }
        }
      }
    }
  }));
  if (resp.rawResponse.aggregations === undefined) {
    return [];
  }
  return resp.rawResponse.aggregations.eventRate.buckets.map(b => ({
    time: b.key,
    value: b.doc_count
  }));
}