"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.FileDataVisualizer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _fileUpload = require("@kbn/file-upload");
var _kibana_services = require("../../kibana_services");
var _file_upload_view = require("./new/file_upload_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/file_data_visualizer/file_data_visualizer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FileDataVisualizer = ({
  getAdditionalLinks,
  resultLinks,
  setUploadResults,
  props
}) => {
  const coreStart = (0, _kibana_services.getCoreStart)();
  const {
    data,
    maps,
    embeddable,
    share,
    fileUpload,
    cloud,
    fieldFormats
  } = (0, _kibana_services.getPluginsStart)();
  const services = {
    ...coreStart,
    data,
    maps,
    embeddable,
    share,
    fileUpload,
    fieldFormats
  };
  const EmptyContext = ({
    children
  }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
  const CloudContext = (cloud === null || cloud === void 0 ? void 0 : cloud.CloudContextProvider) || EmptyContext;
  const {
    autoAddInference,
    autoCreateDataView,
    indexSettings
  } = props !== null && props !== void 0 ? props : {};
  const createFileUploadManager = (0, _react.useCallback)(existingIndex => {
    return new _fileUpload.FileUploadManager(fileUpload, coreStart.http, data, services.notifications, autoAddInference !== null && autoAddInference !== void 0 ? autoAddInference : null, autoCreateDataView, true, existingIndex !== null && existingIndex !== void 0 ? existingIndex : null, indexSettings);
  }, [autoAddInference, autoCreateDataView, coreStart.http, data, fileUpload, indexSettings, services.notifications]);
  const [fileUploadManager, setFileUploadManager] = (0, _react.useState)(() => createFileUploadManager());
  const fileUploadContextValue = (0, _fileUpload.useFileUpload)(fileUploadManager, data, coreStart.application, coreStart.http, coreStart.notifications, undefined);
  const reset = (0, _react.useCallback)(existingIndex => {
    setFileUploadManager(createFileUploadManager(existingIndex));
  }, [createFileUploadManager]);
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, coreStart, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...services
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(CloudContext, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_fileUpload.FileUploadContext.Provider, {
    value: fileUploadContextValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_file_upload_view.FileUploadView, {
    getAdditionalLinks: getAdditionalLinks,
    resultLinks: resultLinks,
    setUploadResults: setUploadResults,
    reset: existingIndex => {
      reset(existingIndex);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 13
    }
  })))));
};

// exporting as default so it can be used with React.lazy
// eslint-disable-next-line import/no-default-export
exports.FileDataVisualizer = FileDataVisualizer;
var _default = exports.default = FileDataVisualizer;