"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useData = void 0;
var _public = require("@kbn/kibana-react-plugin/public");
var _react = require("react");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _rxjs = require("rxjs");
var _public2 = require("@kbn/data-plugin/public");
var _esQuery = require("@kbn/es-query");
var _common = require("@kbn/data-plugin/common");
var _mlTimeBuckets = require("@kbn/ml-time-buckets");
var _use_state_manager = require("../../data_drift/use_state_manager");
var _use_document_count_stats = require("./use_document_count_stats");
var _kibana_context = require("../../kibana_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_BAR_TARGET = 75;
const useData = (initialSettings, selectedDataView, contextId, searchString, searchQueryLanguage, randomSampler, randomSamplerProd, onUpdate, barTarget = DEFAULT_BAR_TARGET, timeRange) => {
  var _docCountRequestParam, _docCountRequestParam2, _docCountRequestParam3, _docCountRequestParam4, _docCountRequestParam5, _docCountRequestParam6, _docCountRequestParam7, _docCountRequestParam8, _docCountRequestParam9;
  const {
    services: {
      executionContext,
      uiSettings,
      data: {
        query: queryManager
      }
    }
  } = (0, _kibana_context.useDataVisualizerKibana)();
  (0, _public.useExecutionContext)(executionContext, {
    name: 'data_visualizer',
    type: 'application',
    id: contextId
  });
  const [lastRefresh, setLastRefresh] = (0, _react.useState)(0);
  const _timeBuckets = (0, _mlTimeBuckets.useTimeBuckets)(uiSettings);
  const timefilter = (0, _mlDatePicker.useTimefilter)({
    timeRangeSelector: (selectedDataView === null || selectedDataView === void 0 ? void 0 : selectedDataView.timeFieldName) !== undefined,
    autoRefreshSelector: true
  });
  const {
    reference: referenceStateManager,
    comparison: comparisonStateManager
  } = (0, _use_state_manager.useDataDriftStateManagerContext)();
  const docCountRequestParams = (0, _react.useMemo)(() => {
    const searchQuery = searchString !== undefined && searchQueryLanguage !== undefined ? {
      query: searchString,
      language: searchQueryLanguage
    } : undefined;
    const timefilterActiveBounds = timeRange !== null && timeRange !== void 0 ? timeRange : timefilter.getActiveBounds();
    if (timefilterActiveBounds !== undefined) {
      var _timefilterActiveBoun, _timefilterActiveBoun2, _timeBuckets$getInter, _referenceStateManage, _comparisonStateManag;
      _timeBuckets.setInterval('auto');
      _timeBuckets.setBounds(timefilterActiveBounds);
      _timeBuckets.setBarTarget(barTarget);
      const query = {
        earliest: (_timefilterActiveBoun = timefilterActiveBounds.min) === null || _timefilterActiveBoun === void 0 ? void 0 : _timefilterActiveBoun.valueOf(),
        latest: (_timefilterActiveBoun2 = timefilterActiveBounds.max) === null || _timefilterActiveBoun2 === void 0 ? void 0 : _timefilterActiveBoun2.valueOf(),
        intervalMs: (_timeBuckets$getInter = _timeBuckets.getInterval()) === null || _timeBuckets$getInter === void 0 ? void 0 : _timeBuckets$getInter.asMilliseconds(),
        timeFieldName: selectedDataView.timeFieldName,
        runtimeFieldMap: selectedDataView.getRuntimeMappings()
      };
      const refQuery = (0, _esQuery.buildEsQuery)(selectedDataView, searchQuery !== null && searchQuery !== void 0 ? searchQuery : [], (0, _public2.mapAndFlattenFilters)([...queryManager.filterManager.getFilters(), ...((_referenceStateManage = referenceStateManager.filters) !== null && _referenceStateManage !== void 0 ? _referenceStateManage : [])]), uiSettings ? (0, _common.getEsQueryConfig)(uiSettings) : undefined);
      const compQuery = (0, _esQuery.buildEsQuery)(selectedDataView, searchQuery !== null && searchQuery !== void 0 ? searchQuery : [], (0, _public2.mapAndFlattenFilters)([...queryManager.filterManager.getFilters(), ...((_comparisonStateManag = comparisonStateManager.filters) !== null && _comparisonStateManag !== void 0 ? _comparisonStateManag : [])]), uiSettings ? (0, _common.getEsQueryConfig)(uiSettings) : undefined);
      return {
        reference: {
          ...query,
          searchQuery: refQuery,
          index: initialSettings ? initialSettings.reference : selectedDataView.getIndexPattern()
        },
        comparison: {
          ...query,
          searchQuery: compQuery,
          index: initialSettings ? initialSettings.comparison : selectedDataView.getIndexPattern()
        }
      };
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [lastRefresh, searchString, searchQueryLanguage,
  // eslint-disable-next-line react-hooks/exhaustive-deps
  JSON.stringify({
    timeRange,
    globalFilters: queryManager.filterManager.getFilters(),
    compFilters: comparisonStateManager === null || comparisonStateManager === void 0 ? void 0 : comparisonStateManager.filters,
    refFilters: referenceStateManager === null || referenceStateManager === void 0 ? void 0 : referenceStateManager.filters
  })]);
  const documentStats = (0, _use_document_count_stats.useDocumentCountStats)(docCountRequestParams === null || docCountRequestParams === void 0 ? void 0 : docCountRequestParams.reference, lastRefresh, randomSampler);
  const documentStatsProd = (0, _use_document_count_stats.useDocumentCountStats)(docCountRequestParams === null || docCountRequestParams === void 0 ? void 0 : docCountRequestParams.comparison, lastRefresh, randomSamplerProd);
  (0, _react.useEffect)(() => {
    const timefilterUpdateSubscription = (0, _rxjs.merge)(timefilter.getAutoRefreshFetch$(), timefilter.getTimeUpdate$(), _mlDatePicker.mlTimefilterRefresh$).subscribe(() => {
      if (onUpdate) {
        onUpdate({
          time: timefilter.getTime(),
          refreshInterval: timefilter.getRefreshInterval()
        });
        setLastRefresh(Date.now());
      }
    });

    // This listens just for an initial update of the timefilter to be switched on.
    const timefilterEnabledSubscription = timefilter.getEnabledUpdated$().subscribe(() => {
      if (docCountRequestParams === undefined) {
        setLastRefresh(Date.now());
      }
    });
    return () => {
      timefilterUpdateSubscription.unsubscribe();
      timefilterEnabledSubscription.unsubscribe();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return {
    documentStats,
    documentStatsProd,
    timefilter,
    /** Start timestamp filter */
    earliest: Math.min((_docCountRequestParam = docCountRequestParams === null || docCountRequestParams === void 0 ? void 0 : (_docCountRequestParam2 = docCountRequestParams.reference) === null || _docCountRequestParam2 === void 0 ? void 0 : _docCountRequestParam2.earliest) !== null && _docCountRequestParam !== void 0 ? _docCountRequestParam : 0, (_docCountRequestParam3 = docCountRequestParams === null || docCountRequestParams === void 0 ? void 0 : (_docCountRequestParam4 = docCountRequestParams.comparison) === null || _docCountRequestParam4 === void 0 ? void 0 : _docCountRequestParam4.earliest) !== null && _docCountRequestParam3 !== void 0 ? _docCountRequestParam3 : 0),
    /** End timestamp filter */
    latest: Math.max((_docCountRequestParam5 = docCountRequestParams === null || docCountRequestParams === void 0 ? void 0 : (_docCountRequestParam6 = docCountRequestParams.reference) === null || _docCountRequestParam6 === void 0 ? void 0 : _docCountRequestParam6.latest) !== null && _docCountRequestParam5 !== void 0 ? _docCountRequestParam5 : 0, (_docCountRequestParam7 = docCountRequestParams === null || docCountRequestParams === void 0 ? void 0 : (_docCountRequestParam8 = docCountRequestParams.comparison) === null || _docCountRequestParam8 === void 0 ? void 0 : _docCountRequestParam8.latest) !== null && _docCountRequestParam7 !== void 0 ? _docCountRequestParam7 : 0),
    intervalMs: docCountRequestParams === null || docCountRequestParams === void 0 ? void 0 : (_docCountRequestParam9 = docCountRequestParams.reference) === null || _docCountRequestParam9 === void 0 ? void 0 : _docCountRequestParam9.intervalMs,
    forceRefresh: () => setLastRefresh(Date.now())
  };
};
exports.useData = useData;