"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.filterFields = filterFields;
exports.matchFieldType = matchFieldType;
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function matchFieldType(fieldType, config) {
  return fieldType === config.secondaryType || fieldType === config.type;
}
function filterFields(fields, visibleFieldNames, visibleFieldTypes) {
  let items = fields;
  if (visibleFieldTypes && visibleFieldTypes.length > 0) {
    items = items.filter(config => visibleFieldTypes.findIndex(fieldType => matchFieldType(fieldType, config)) > -1);
  }
  if (visibleFieldNames && visibleFieldNames.length > 0) {
    items = items.filter(config => {
      return visibleFieldNames.findIndex(fieldName => fieldName === config.fieldName) > -1;
    });
  }
  return {
    filteredFields: items,
    visibleFieldsCount: items.length,
    visibleMetricsCount: items.filter(d => d.type === _constants.SUPPORTED_FIELD_TYPES.NUMBER).length
  };
}