"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetDataUsageDataStreams = void 0;
var _reactQuery = require("@kbn/react-query");
var _common = require("../../common");
var _use_kibana = require("../utils/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetDataUsageDataStreams = ({
  selectedDataStreams,
  options = {
    enabled: false
  }
}) => {
  const {
    http
  } = (0, _use_kibana.useKibanaContextForPlugin)().services;
  return (0, _reactQuery.useQuery)({
    queryKey: ['get-data-usage-data-streams'],
    ...options,
    keepPreviousData: true,
    queryFn: async ({
      signal
    }) => {
      return http.get(_common.DATA_USAGE_DATA_STREAMS_API_ROUTE, {
        signal,
        version: '1'
      }).then(response => {
        const augmentedDataStreamsBasedOnSelectedItems = response.reduce((acc, ds, i) => {
          const item = {
            name: ds.name,
            storageSizeBytes: ds.storageSizeBytes,
            selected: ds.selected
          };
          if (selectedDataStreams !== null && selectedDataStreams !== void 0 && selectedDataStreams.includes(ds.name) && i < _common.DEFAULT_SELECTED_OPTIONS) {
            acc.selected.push({
              ...item,
              selected: true
            });
          } else {
            acc.rest.push({
              ...item,
              selected: false
            });
          }
          return acc;
        }, {
          selected: [],
          rest: []
        });
        return [...augmentedDataStreamsBasedOnSelectedItems.selected, ...augmentedDataStreamsBasedOnSelectedItems.rest];
      }).catch(error => {
        throw error.body;
      });
    }
  });
};
exports.useGetDataUsageDataStreams = useGetDataUsageDataStreams;