"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapToUISession = void 0;
var _get_actions = require("./get_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getUrlFromState(locators, locatorId, state) {
  try {
    const locator = locators.get(locatorId);
    return locator === null || locator === void 0 ? void 0 : locator.getRedirectUrl(state);
  } catch (err) {
    // eslint-disable-next-line no-console
    console.error('Could not create URL from restoreState');
    // eslint-disable-next-line no-console
    console.error(err);
  }
}

// Helper: factory for a function to map server objects to UI objects
const mapToUISession = ({
  savedObject,
  locators,
  sessionStatuses,
  actions: filteredActions,
  enableOpeningInNewTab
}) => {
  var _sessionStatuses$save, _sessionStatuses$save2;
  const {
    name,
    appId,
    created,
    expires,
    locatorId,
    initialState,
    restoreState,
    idMapping,
    version
  } = savedObject.attributes;
  const status = (_sessionStatuses$save = sessionStatuses[savedObject.id]) === null || _sessionStatuses$save === void 0 ? void 0 : _sessionStatuses$save.status;
  const errors = (_sessionStatuses$save2 = sessionStatuses[savedObject.id]) === null || _sessionStatuses$save2 === void 0 ? void 0 : _sessionStatuses$save2.errors;
  const actions = (0, _get_actions.getActions)(status).filter(action => {
    if (!(filteredActions !== null && filteredActions !== void 0 && filteredActions.length)) return true; // if no actions are provided, return all
    return filteredActions.includes(action);
  });

  // TODO: initialState should be saved without the searchSessionID
  if (initialState) delete initialState.searchSessionId;
  // derive the URL and add it in
  const reloadUrl = getUrlFromState(locators, locatorId, initialState);
  const restoreUrl = getUrlFromState(locators, locatorId, enableOpeningInNewTab ? {
    ...restoreState,
    tab: {
      id: 'new',
      label: name
    }
  } : restoreState);
  return {
    id: savedObject.id,
    name,
    appId,
    created,
    expires,
    status,
    actions,
    restoreUrl: restoreUrl,
    reloadUrl: reloadUrl,
    initialState,
    restoreState,
    idMapping,
    numSearches: Object.keys(idMapping).length,
    version,
    errors
  };
};
exports.mapToUISession = mapToUISession;