"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _searchResponseWarnings = require("@kbn/search-response-warnings");
var _request = require("@kbn/inspector-plugin/common/adapters/request");
var _rxjs = require("rxjs");
var _search = require("../../common/search");
var _shard_delay = require("../../common/search/aggs/buckets/shard_delay");
var _shard_delay_fn = require("../../common/search/aggs/buckets/shard_delay_fn");
var _aggs = require("./aggs");
var _collectors = require("./collectors");
var _expressions = require("./expressions");
var _search_interceptor = require("./search_interceptor");
var _session = require("./session");
var _sessions_mgmt = require("./session/sessions_mgmt");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @internal */

/** @internal */

class SearchService {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "aggsService", new _aggs.AggsService());
    (0, _defineProperty2.default)(this, "searchSourceService", new _search.SearchSourceService());
    (0, _defineProperty2.default)(this, "searchInterceptor", void 0);
    (0, _defineProperty2.default)(this, "usageCollector", void 0);
    (0, _defineProperty2.default)(this, "sessionService", void 0);
    (0, _defineProperty2.default)(this, "sessionsClient", void 0);
    this.initializerContext = initializerContext;
  }
  setup(core, {
    expressions,
    usageCollection,
    nowProvider,
    management
  }) {
    const {
      http,
      getStartServices,
      notifications,
      uiSettings,
      executionContext
    } = core;
    this.usageCollector = (0, _collectors.createUsageCollector)(getStartServices, usageCollection);
    this.sessionsClient = new _session.SessionsClient({
      http
    });
    this.sessionService = new _session.SessionService(this.initializerContext, getStartServices, this.sessionsClient, nowProvider, this.usageCollector);
    /**
     * A global object that intercepts all searches and provides convenience methods for cancelling
     * all pending search requests, as well as getting the number of pending search requests.
     */
    this.searchInterceptor = new _search_interceptor.SearchInterceptor({
      toasts: notifications.toasts,
      executionContext,
      http,
      uiSettings,
      startServices: getStartServices(),
      usageCollector: this.usageCollector,
      session: this.sessionService,
      searchConfig: this.initializerContext.config.get().search
    });
    expressions.registerFunction((0, _expressions.getEsaggs)({
      getStartServices
    }));
    expressions.registerFunction(_search.kibana);
    expressions.registerFunction(_search.cidrFunction);
    expressions.registerFunction(_search.dateRangeFunction);
    expressions.registerFunction(_search.extendedBoundsFunction);
    expressions.registerFunction(_search.ipPrefixFunction);
    expressions.registerFunction(_search.ipRangeFunction);
    expressions.registerFunction(_search.luceneFunction);
    expressions.registerFunction(_search.kqlFunction);
    expressions.registerFunction(_search.kibanaTimerangeFunction);
    expressions.registerFunction(_search.fieldFunction);
    expressions.registerFunction(_search.numericalRangeFunction);
    expressions.registerFunction(_search.geoBoundingBoxFunction);
    expressions.registerFunction(_search.geoPointFunction);
    expressions.registerFunction(_search.rangeFunction);
    expressions.registerFunction(_search.kibanaFilterFunction);
    expressions.registerFunction(_search.existsFilterFunction);
    expressions.registerFunction(_search.queryFilterFunction);
    expressions.registerFunction(_search.rangeFilterFunction);
    expressions.registerFunction(_search.removeFilterFunction);
    expressions.registerFunction(_search.selectFilterFunction);
    expressions.registerFunction(_search.phraseFilterFunction);
    expressions.registerFunction((0, _expressions.getEsdsl)({
      getStartServices
    }));
    expressions.registerFunction((0, _expressions.getEssql)({
      getStartServices
    }));
    expressions.registerFunction((0, _expressions.getEsql)({
      getStartServices
    }));
    expressions.registerFunction((0, _expressions.getEql)({
      getStartServices
    }));
    expressions.registerType(_search.esRawResponse);
    expressions.registerType(_search.eqlRawResponse);
    const aggs = this.aggsService.setup({
      uiSettings,
      registerFunction: expressions.registerFunction,
      nowProvider
    });
    if (this.initializerContext.config.get().search.aggs.shardDelay.enabled) {
      aggs.types.registerBucket(_shard_delay.SHARD_DELAY_AGG_NAME, _shard_delay.getShardDelayBucketAgg);
      expressions.registerFunction(_shard_delay_fn.aggShardDelay);
    }
    const config = this.initializerContext.config.get();
    if (config.search.sessions.enabled) {
      const sessionsConfig = config.search.sessions;
      (0, _sessions_mgmt.registerSearchSessionsMgmt)(core, {
        management,
        searchUsageCollector: this.usageCollector,
        sessionsClient: this.sessionsClient
      }, sessionsConfig, this.initializerContext.env.packageInfo.version);
    }
    return {
      aggs,
      usageCollector: this.usageCollector,
      session: this.sessionService,
      sessionsClient: this.sessionsClient
    };
  }
  start(coreStart, {
    fieldFormats,
    indexPatterns,
    inspector,
    screenshotMode,
    scriptedFieldsEnabled,
    share
  }) {
    const {
      http,
      uiSettings,
      chrome,
      application,
      notifications,
      ...startServices
    } = coreStart;
    const search = (request, options = {}) => {
      return this.searchInterceptor.search(request, options);
    };
    const loadingCount$ = new _rxjs.BehaviorSubject(0);
    http.addLoadingCountSource(loadingCount$);
    const aggs = this.aggsService.start({
      fieldFormats,
      indexPatterns
    });
    const warningsServices = {
      inspector,
      notifications,
      ...startServices
    };
    const searchSourceDependencies = {
      aggs,
      getConfig: uiSettings.get.bind(uiSettings),
      search,
      dataViews: indexPatterns,
      onResponse: (request, response, options) => {
        if (!options.disableWarningToasts) {
          var _options$inspector, _options$inspector2, _options$inspector3, _options$inspector4;
          const {
            rawResponse
          } = response;
          const requestName = (_options$inspector = options.inspector) !== null && _options$inspector !== void 0 && _options$inspector.title ? options.inspector.title : _i18n.i18n.translate('data.searchService.anonymousRequestTitle', {
            defaultMessage: 'Request'
          });
          const requestAdapter = (_options$inspector2 = options.inspector) !== null && _options$inspector2 !== void 0 && _options$inspector2.adapter ? (_options$inspector3 = options.inspector) === null || _options$inspector3 === void 0 ? void 0 : _options$inspector3.adapter : new _request.RequestAdapter();
          if (!((_options$inspector4 = options.inspector) !== null && _options$inspector4 !== void 0 && _options$inspector4.adapter)) {
            const requestResponder = requestAdapter.start(requestName, {
              id: request.id
            });
            requestResponder.json(request.body);
            requestResponder.ok({
              json: response
            });
          }
          (0, _searchResponseWarnings.handleWarnings)({
            request: request.body,
            requestAdapter,
            requestId: request.id,
            requestName,
            response: rawResponse,
            services: warningsServices
          });
        }
        return response;
      },
      scriptedFieldsEnabled
    };
    const config = this.initializerContext.config.get();
    return {
      aggs,
      search,
      showError: e => {
        this.searchInterceptor.showError(e);
      },
      showSearchSessionsFlyout: (0, _sessions_mgmt.openSearchSessionsFlyout)({
        coreStart,
        kibanaVersion: this.initializerContext.env.packageInfo.version,
        usageCollector: this.usageCollector,
        config: config.search.sessions,
        sessionsClient: this.sessionsClient,
        share
      }),
      showWarnings: (adapter, callback) => {
        adapter === null || adapter === void 0 ? void 0 : adapter.getRequests().forEach(request => {
          var _request$response, _request$response$jso;
          const rawResponse = (_request$response = request.response) === null || _request$response === void 0 ? void 0 : (_request$response$jso = _request$response.json) === null || _request$response$jso === void 0 ? void 0 : _request$response$jso.rawResponse;
          if (!rawResponse) {
            return;
          }
          (0, _searchResponseWarnings.handleWarnings)({
            callback,
            request: request.json,
            requestAdapter: adapter,
            requestId: request.id,
            requestName: request.name,
            response: rawResponse,
            services: warningsServices
          });
        });
      },
      isBackgroundSearchEnabled: config.search.sessions.enabled,
      session: this.sessionService,
      sessionsClient: this.sessionsClient,
      searchSource: this.searchSourceService.start(indexPatterns, searchSourceDependencies)
    };
  }
  stop() {
    this.aggsService.stop();
    this.searchSourceService.stop();
    this.searchInterceptor.stop();
  }
}
exports.SearchService = SearchService;