"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapQueryString = void 0;
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const mapQueryString = filter => {
  if ((0, _esQuery.isQueryStringFilter)(filter)) {
    var _filter$query, _filter$query$query_s;
    return {
      type: _esQuery.FILTERS.QUERY_STRING,
      key: 'query',
      value: (_filter$query = filter.query) === null || _filter$query === void 0 ? void 0 : (_filter$query$query_s = _filter$query.query_string) === null || _filter$query$query_s === void 0 ? void 0 : _filter$query$query_s.query
    };
  }
  throw filter;
};
exports.mapQueryString = mapQueryString;