"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPhraseDisplayValue = getPhraseDisplayValue;
exports.mapPhrase = exports.isMapPhraseFilter = void 0;
var _lodash = require("lodash");
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getScriptedPhraseValue = filter => (0, _lodash.get)(filter, ['query', 'script', 'script', 'params', 'value']);
function getPhraseDisplayValue(filter, formatter, fieldType) {
  var _filter$meta$value, _filter$meta$params;
  const value = (_filter$meta$value = filter.meta.value) !== null && _filter$meta$value !== void 0 ? _filter$meta$value : (_filter$meta$params = filter.meta.params) === null || _filter$meta$params === void 0 ? void 0 : _filter$meta$params.query;
  const updatedValue = fieldType === 'number' && !value ? 0 : value;
  if (formatter !== null && formatter !== void 0 && formatter.convert) {
    return formatter.convert(updatedValue);
  }
  return updatedValue === undefined ? '' : `${updatedValue}`;
}
const getParams = filter => {
  const scriptedPhraseValue = getScriptedPhraseValue(filter);
  const isScriptedFilter = Boolean(scriptedPhraseValue);
  const key = isScriptedFilter ? filter.meta.field || '' : (0, _esQuery.getPhraseFilterField)(filter);
  const query = scriptedPhraseValue || (0, _esQuery.getPhraseFilterValue)(filter);
  const params = {
    query
  };
  return {
    key,
    params,
    type: _esQuery.FILTERS.PHRASE
  };
};
const isMapPhraseFilter = filter => (0, _esQuery.isPhraseFilter)(filter) || (0, _esQuery.isScriptedPhraseFilter)(filter);
exports.isMapPhraseFilter = isMapPhraseFilter;
const mapPhrase = filter => {
  if (!isMapPhraseFilter(filter)) {
    throw filter;
  }
  return getParams(filter);
};
exports.mapPhrase = mapPhrase;