"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.queryToFields = queryToFields;
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const collectFilterFields = (filter, acc = []) => {
  var _filter$meta, _filter$meta$key, _filter$meta2;
  if (!(0, _esQuery.isFilter)(filter) || ((_filter$meta = filter.meta) === null || _filter$meta === void 0 ? void 0 : _filter$meta.disabled) === true) return acc;
  if ((0, _esQuery.isCombinedFilter)(filter)) {
    for (const nested of (_filter$meta$params = filter.meta.params) !== null && _filter$meta$params !== void 0 ? _filter$meta$params : []) {
      var _filter$meta$params;
      collectFilterFields(nested, acc);
    }
    return acc;
  }
  const field = (_filter$meta$key = (_filter$meta2 = filter.meta) === null || _filter$meta2 === void 0 ? void 0 : _filter$meta2.key) !== null && _filter$meta$key !== void 0 ? _filter$meta$key : (0, _esQuery.getFilterField)(filter);
  if (field) acc.push(field);
  return acc;
};
async function queryToFields({
  dataView,
  sort,
  request
}) {
  let fields = dataView.timeFieldName ? [dataView.timeFieldName] : [];
  if (sort) {
    const sortArr = Array.isArray(sort) ? sort : [sort];
    fields.push(...sortArr.flatMap(s => Object.keys(s)));
  }
  for (const query of ((_request$query = request.query) !== null && _request$query !== void 0 ? _request$query : []).filter(_esQuery.isOfQueryType)) {
    var _request$query;
    if (query.query && query.language === 'kuery') {
      const nodes = (0, _esQuery.fromKueryExpression)(query.query);
      const queryFields = (0, _esQuery.getKqlFieldNames)(nodes);
      fields = fields.concat(queryFields);
    }
  }
  const {
    filters = []
  } = request;
  const requestFilters = typeof filters === 'function' ? filters() : filters;
  fields = fields.concat(requestFilters.flatMap(filter => collectFilterFields(filter)));

  // if source filtering is enabled, we need to fetch all the fields
  const fieldName = dataView.getSourceFiltering() && dataView.getSourceFiltering().excludes.length ? ['*'] : fields;
  if (fieldName.length) {
    return (await dataView.getFields({
      fieldName
    })).getFieldMapSorted();
  }

  // no fields needed to be loaded for query
  return {};
}