"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "PUBLIC_API_PATH", {
  enumerable: true,
  get: function () {
    return _constants.PUBLIC_API_PATH;
  }
});
exports.configSchema = exports.config = void 0;
exports.plugin = plugin;
var _configSchema = require("@kbn/config-schema");
var _constants = require("./api/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const configSchema = exports.configSchema = _configSchema.schema.object({
  /**
   * this config is unused, but cannot be removed as removing a yml setting is a breaking change.
   * This can be removed in 10.0. https://github.com/elastic/kibana/issues/221197
   */
  allowByValueEmbeddables: _configSchema.schema.boolean({
    defaultValue: true
  })
});
const config = exports.config = {
  schema: configSchema,
  deprecations: ({
    deprecate
  }) => {
    return [deprecate('allowByValueEmbeddables', '9.1.0', {
      level: 'warning',
      message: `This setting is deprecated and ignored by the system. Please remove this setting.`
    })];
  }
};

//  This exports static code and TypeScript types,
//  as well as, Kibana Platform `plugin()` initializer.

async function plugin(initializerContext) {
  const {
    DashboardPlugin
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('./plugin')));
  return new DashboardPlugin(initializerContext);
}