"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDashboardSavedObjectType = exports.DASHBOARD_SAVED_OBJECT_TYPE = void 0;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _v = require("./schema/v1");
var _v2 = require("./schema/v2");
var _v3 = require("./schema/v3");
var _dashboard_saved_object_migrations = require("./migrations/dashboard_saved_object_migrations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DASHBOARD_SAVED_OBJECT_TYPE = exports.DASHBOARD_SAVED_OBJECT_TYPE = 'dashboard';
const createDashboardSavedObjectType = ({
  migrationDeps
}) => ({
  name: DASHBOARD_SAVED_OBJECT_TYPE,
  indexPattern: _coreSavedObjectsServer.ANALYTICS_SAVED_OBJECT_INDEX,
  hidden: false,
  namespaceType: 'multiple-isolated',
  convertToMultiNamespaceTypeVersion: '8.0.0',
  management: {
    icon: 'dashboardApp',
    defaultSearchField: 'title',
    importableAndExportable: true,
    getTitle(obj) {
      return obj.attributes.title;
    },
    getInAppUrl(obj) {
      return {
        path: `/app/dashboards#/view/${encodeURIComponent(obj.id)}`,
        uiCapabilitiesPath: 'dashboard_v2.show'
      };
    }
  },
  modelVersions: {
    1: {
      changes: [],
      schemas: {
        forwardCompatibility: _v.dashboardAttributesSchema.extends({}, {
          unknowns: 'ignore'
        }),
        create: _v.dashboardAttributesSchema
      }
    },
    2: {
      changes: [{
        type: 'mappings_addition',
        addedMappings: {
          controlGroupInput: {
            properties: {
              showApplySelections: {
                type: 'boolean',
                index: false,
                doc_values: false
              }
            }
          }
        }
      }],
      schemas: {
        forwardCompatibility: _v2.dashboardAttributesSchema.extends({}, {
          unknowns: 'ignore'
        }),
        create: _v2.dashboardAttributesSchema
      }
    },
    3: {
      changes: [{
        type: 'mappings_addition',
        addedMappings: {
          sections: {
            properties: {},
            dynamic: false
          }
        }
      }],
      schemas: {
        forwardCompatibility: _v3.dashboardAttributesSchema.extends({}, {
          unknowns: 'ignore'
        }),
        create: _v3.dashboardAttributesSchema
      }
    }
  },
  mappings: {
    dynamic: false,
    properties: {
      description: {
        type: 'text'
      },
      hits: {
        type: 'integer',
        index: false,
        doc_values: false
      },
      kibanaSavedObjectMeta: {
        properties: {
          searchSourceJSON: {
            type: 'text',
            index: false
          }
        }
      },
      optionsJSON: {
        type: 'text',
        index: false
      },
      panelsJSON: {
        type: 'text',
        index: false
      },
      sections: {
        properties: {},
        dynamic: false
      },
      refreshInterval: {
        properties: {
          display: {
            type: 'keyword',
            index: false,
            doc_values: false
          },
          pause: {
            type: 'boolean',
            index: false,
            doc_values: false
          },
          section: {
            type: 'integer',
            index: false,
            doc_values: false
          },
          value: {
            type: 'integer',
            index: false,
            doc_values: false
          }
        }
      },
      controlGroupInput: {
        properties: {
          controlStyle: {
            type: 'keyword',
            index: false,
            doc_values: false
          },
          chainingSystem: {
            type: 'keyword',
            index: false,
            doc_values: false
          },
          panelsJSON: {
            type: 'text',
            index: false
          },
          showApplySelections: {
            type: 'boolean',
            index: false,
            doc_values: false
          },
          ignoreParentSettingsJSON: {
            type: 'text',
            index: false
          }
        }
      },
      timeFrom: {
        type: 'keyword',
        index: false,
        doc_values: false
      },
      timeRestore: {
        type: 'boolean',
        index: false,
        doc_values: false
      },
      timeTo: {
        type: 'keyword',
        index: false,
        doc_values: false
      },
      title: {
        type: 'text'
      },
      version: {
        type: 'integer'
      }
    }
  },
  schemas: {
    '8.9.0': _v.dashboardAttributesSchema
  },
  migrations: () => (0, _dashboard_saved_object_migrations.createDashboardSavedObjectTypeMigrations)(migrationDeps)
});
exports.createDashboardSavedObjectType = createDashboardSavedObjectType;