"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformControlGroupOut = void 0;
var _lodash = require("lodash");
var _controlsConstants = require("@kbn/controls-constants");
var _transform_controls_state = require("./transform_controls_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const transformControlGroupOut = exports.transformControlGroupOut = (0, _lodash.flow)(transformControlGroupSetDefaults, transformControlGroupProperties);

// TODO We may want to remove setting defaults in the future
function transformControlGroupSetDefaults(controlGroupInput) {
  return {
    controlStyle: _controlsConstants.DEFAULT_CONTROLS_LABEL_POSITION,
    chainingSystem: _controlsConstants.DEFAULT_CONTROLS_CHAINING,
    showApplySelections: !_controlsConstants.DEFAULT_AUTO_APPLY_SELECTIONS,
    ...controlGroupInput
  };
}
function transformControlGroupProperties({
  controlStyle,
  chainingSystem,
  showApplySelections,
  ignoreParentSettingsJSON,
  panelsJSON
}) {
  return {
    labelPosition: controlStyle,
    chainingSystem: chainingSystem,
    autoApplySelections: !showApplySelections,
    ignoreParentSettings: ignoreParentSettingsJSON ? (0, _lodash.flow)(JSON.parse, transformIgnoreParentSettingsSetDefaults, transformIgnoreParentSettingsProperties)(ignoreParentSettingsJSON) : _controlsConstants.DEFAULT_IGNORE_PARENT_SETTINGS,
    controls: panelsJSON ? (0, _transform_controls_state.transformControlsState)(panelsJSON) : []
  };
}

// TODO We may want to remove setting defaults in the future
function transformIgnoreParentSettingsSetDefaults(ignoreParentSettings) {
  return {
    ..._controlsConstants.DEFAULT_IGNORE_PARENT_SETTINGS,
    ...ignoreParentSettings
  };
}

/**
 * Explicitly extract and provide the expected properties ignoring any unsupported
 * properties that may be in the saved object.
 */
function transformIgnoreParentSettingsProperties({
  ignoreFilters,
  ignoreQuery,
  ignoreTimerange,
  ignoreValidations
}) {
  return {
    ignoreFilters,
    ignoreQuery,
    ignoreTimerange,
    ignoreValidations
  };
}