"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteDashboards = void 0;
var _telemetry_constants = require("../../../utils/telemetry_constants");
var _ = require("..");
var _kibana_services = require("../../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const deleteDashboards = async ids => {
  const deletePromises = ids.map(id => {
    (0, _.getDashboardContentManagementCache)().deleteDashboard(id);
    return _kibana_services.contentManagementService.client.delete({
      contentTypeId: _telemetry_constants.DASHBOARD_CONTENT_ID,
      id
    });
  });
  await Promise.all(deletePromises);
};
exports.deleteDashboards = deleteDashboards;