"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDashboardContentManagementService = exports.getDashboardContentManagementCache = void 0;
var _dashboard_content_management_cache = require("./dashboard_content_management_cache");
var _check_for_duplicate_dashboard_title = require("./lib/check_for_duplicate_dashboard_title");
var _delete_dashboards = require("./lib/delete_dashboards");
var _find_dashboards = require("./lib/find_dashboards");
var _load_dashboard_state = require("./lib/load_dashboard_state");
var _save_dashboard_state = require("./lib/save_dashboard_state");
var _update_dashboard_meta = require("./lib/update_dashboard_meta");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

let dashboardContentManagementCache;
const getDashboardContentManagementCache = () => {
  if (!dashboardContentManagementCache) dashboardContentManagementCache = new _dashboard_content_management_cache.DashboardContentManagementCache();
  return dashboardContentManagementCache;
};
exports.getDashboardContentManagementCache = getDashboardContentManagementCache;
const getDashboardContentManagementService = () => {
  return {
    loadDashboardState: _load_dashboard_state.loadDashboardState,
    saveDashboardState: _save_dashboard_state.saveDashboardState,
    findDashboards: {
      search: _find_dashboards.searchDashboards,
      findById: _find_dashboards.findDashboardById,
      findByIds: _find_dashboards.findDashboardsByIds,
      findByTitle: _find_dashboards.findDashboardIdByTitle
    },
    checkForDuplicateDashboardTitle: _check_for_duplicate_dashboard_title.checkForDuplicateDashboardTitle,
    deleteDashboards: _delete_dashboards.deleteDashboards,
    updateDashboardMeta: _update_dashboard_meta.updateDashboardMeta
  };
};
exports.getDashboardContentManagementService = getDashboardContentManagementService;