"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDashboardListingTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _contentManagementContentInsightsPublic = require("@kbn/content-management-content-insights-public");
var _ebtTools = require("@kbn/ebt-tools");
var _telemetry_constants = require("../../utils/telemetry_constants");
var _dashboard_backup_service = require("../../services/dashboard_backup_service");
var _dashboard_content_management_service = require("../../services/dashboard_content_management_service");
var _dashboard_recently_accessed_service = require("../../services/dashboard_recently_accessed_service");
var _kibana_services = require("../../services/kibana_services");
var _logger = require("../../services/logger");
var _get_dashboard_capabilities = require("../../utils/get_dashboard_capabilities");
var _dashboard_listing_strings = require("../_dashboard_listing_strings");
var _confirm_overlays = require("../confirm_overlays");
var _dashboard_listing_empty_prompt = require("../dashboard_listing_empty_prompt");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/dashboard/public/dashboard_listing/hooks/use_dashboard_listing_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SAVED_OBJECTS_LIMIT_SETTING = 'savedObjects:listingLimit';
const SAVED_OBJECTS_PER_PAGE_SETTING = 'savedObjects:perPage';
const toTableListViewSavedObject = hit => {
  var _hit$references;
  const {
    title,
    description,
    timeRestore
  } = hit.attributes;
  return {
    type: 'dashboard',
    id: hit.id,
    updatedAt: hit.updatedAt,
    createdAt: hit.createdAt,
    createdBy: hit.createdBy,
    updatedBy: hit.updatedBy,
    references: (_hit$references = hit.references) !== null && _hit$references !== void 0 ? _hit$references : [],
    managed: hit.managed,
    attributes: {
      title,
      description,
      timeRestore
    }
  };
};
const useDashboardListingTable = ({
  dashboardListingId = 'dashboard',
  disableCreateDashboardButton,
  getDashboardUrl,
  goToDashboard,
  headingId = 'dashboardListingHeading',
  initialFilter,
  urlStateEnabled,
  useSessionStorageIntegration,
  showCreateDashboardButton = true
}) => {
  const {
    getEntityName,
    getTableListTitle,
    getEntityNamePlural
  } = _dashboard_listing_strings.dashboardListingTableStrings;
  const title = getTableListTitle();
  const entityName = getEntityName();
  const entityNamePlural = getEntityNamePlural();
  const [pageDataTestSubject, setPageDataTestSubject] = (0, _react.useState)();
  const [hasInitialFetchReturned, setHasInitialFetchReturned] = (0, _react.useState)(false);
  const dashboardBackupService = (0, _react.useMemo)(() => (0, _dashboard_backup_service.getDashboardBackupService)(), []);
  const dashboardContentManagementService = (0, _react.useMemo)(() => (0, _dashboard_content_management_service.getDashboardContentManagementService)(), []);
  const [unsavedDashboardIds, setUnsavedDashboardIds] = (0, _react.useState)(dashboardBackupService.getDashboardIdsWithUnsavedChanges());
  const listingLimit = _kibana_services.coreServices.uiSettings.get(SAVED_OBJECTS_LIMIT_SETTING);
  const initialPageSize = _kibana_services.coreServices.uiSettings.get(SAVED_OBJECTS_PER_PAGE_SETTING);
  const createItem = (0, _react.useCallback)(() => {
    if (useSessionStorageIntegration && dashboardBackupService.dashboardHasUnsavedEdits()) {
      (0, _confirm_overlays.confirmCreateWithUnsaved)(() => {
        dashboardBackupService.clearState();
        goToDashboard();
      }, goToDashboard);
      return;
    }
    goToDashboard();
  }, [dashboardBackupService, goToDashboard, useSessionStorageIntegration]);
  const updateItemMeta = (0, _react.useCallback)(async props => {
    await dashboardContentManagementService.updateDashboardMeta(props);
    setUnsavedDashboardIds(dashboardBackupService.getDashboardIdsWithUnsavedChanges());
  }, [dashboardBackupService, dashboardContentManagementService]);
  const contentEditorValidators = (0, _react.useMemo)(() => ({
    title: [{
      type: 'warning',
      fn: async (value, id) => {
        if (id) {
          try {
            const [dashboard] = await dashboardContentManagementService.findDashboards.findByIds([id]);
            if (dashboard.status === 'error') {
              return;
            }
            const validTitle = await dashboardContentManagementService.checkForDuplicateDashboardTitle({
              title: value,
              copyOnSave: false,
              lastSavedTitle: dashboard.attributes.title,
              isTitleDuplicateConfirmed: false
            });
            if (!validTitle) {
              throw new Error(_dashboard_listing_strings.dashboardListingErrorStrings.getDuplicateTitleWarning(value));
            }
          } catch (e) {
            return e.message;
          }
        }
      }
    }]
  }), [dashboardContentManagementService]);
  const emptyPrompt = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_dashboard_listing_empty_prompt.DashboardListingEmptyPrompt, {
    createItem: createItem,
    disableCreateDashboardButton: disableCreateDashboardButton,
    goToDashboard: goToDashboard,
    setUnsavedDashboardIds: setUnsavedDashboardIds,
    unsavedDashboardIds: unsavedDashboardIds,
    useSessionStorageIntegration: useSessionStorageIntegration,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 7
    }
  }), [createItem, disableCreateDashboardButton, goToDashboard, unsavedDashboardIds, useSessionStorageIntegration]);
  const findItems = (0, _react.useCallback)((searchTerm, {
    references,
    referencesToExclude
  } = {}) => {
    const searchStartTime = window.performance.now();
    return dashboardContentManagementService.findDashboards.search({
      search: searchTerm,
      size: listingLimit,
      hasReference: references,
      hasNoReference: referencesToExclude,
      options: {
        // include only tags references in the response to save bandwidth
        includeReferences: ['tag'],
        fields: ['title', 'description', 'timeRestore']
      }
    }).then(({
      total,
      hits
    }) => {
      const searchEndTime = window.performance.now();
      const searchDuration = searchEndTime - searchStartTime;
      (0, _ebtTools.reportPerformanceMetricEvent)(_kibana_services.coreServices.analytics, {
        eventName: _telemetry_constants.SAVED_OBJECT_LOADED_TIME,
        duration: searchDuration,
        meta: {
          saved_object_type: _telemetry_constants.DASHBOARD_CONTENT_ID
        }
      });
      return {
        total,
        hits: hits.map(toTableListViewSavedObject)
      };
    });
  }, [listingLimit, dashboardContentManagementService]);
  const deleteItems = (0, _react.useCallback)(async dashboardsToDelete => {
    try {
      const deleteStartTime = window.performance.now();
      await dashboardContentManagementService.deleteDashboards(dashboardsToDelete.map(({
        id
      }) => {
        dashboardBackupService.clearState(id);
        return id;
      }));
      const deleteDuration = window.performance.now() - deleteStartTime;
      (0, _ebtTools.reportPerformanceMetricEvent)(_kibana_services.coreServices.analytics, {
        eventName: _telemetry_constants.SAVED_OBJECT_DELETE_TIME,
        duration: deleteDuration,
        meta: {
          saved_object_type: _telemetry_constants.DASHBOARD_CONTENT_ID,
          total: dashboardsToDelete.length
        }
      });
    } catch (error) {
      _kibana_services.coreServices.notifications.toasts.addError(error, {
        title: _dashboard_listing_strings.dashboardListingErrorStrings.getErrorDeletingDashboardToast()
      });
    }
    setUnsavedDashboardIds(dashboardBackupService.getDashboardIdsWithUnsavedChanges());
  }, [dashboardBackupService, dashboardContentManagementService]);
  const editItem = (0, _react.useCallback)(({
    id
  }) => goToDashboard(id, 'edit'), [goToDashboard]);
  const onFetchSuccess = (0, _react.useCallback)(() => {
    if (!hasInitialFetchReturned) {
      setHasInitialFetchReturned(true);
    }
  }, [hasInitialFetchReturned]);
  const getDetailViewLink = (0, _react.useCallback)(({
    id,
    attributes: {
      timeRestore
    }
  }) => getDashboardUrl(id, timeRestore), [getDashboardUrl]);
  const tableListViewTableProps = (0, _react.useMemo)(() => {
    const {
      showWriteControls
    } = (0, _get_dashboard_capabilities.getDashboardCapabilities)();
    return {
      contentEditor: {
        isReadonly: !showWriteControls,
        onSave: updateItemMeta,
        customValidators: contentEditorValidators
      },
      createItem: !showWriteControls || !showCreateDashboardButton ? undefined : createItem,
      deleteItems: !showWriteControls ? undefined : deleteItems,
      editItem: !showWriteControls ? undefined : editItem,
      emptyPrompt,
      entityName,
      entityNamePlural,
      findItems,
      getDetailViewLink,
      headingId,
      id: dashboardListingId,
      initialFilter,
      initialPageSize,
      listingLimit,
      onFetchSuccess,
      setPageDataTestSubject,
      title,
      urlStateEnabled,
      createdByEnabled: true,
      recentlyAccessed: (0, _dashboard_recently_accessed_service.getDashboardRecentlyAccessedService)()
    };
  }, [contentEditorValidators, createItem, dashboardListingId, deleteItems, editItem, emptyPrompt, entityName, entityNamePlural, findItems, getDetailViewLink, headingId, initialFilter, initialPageSize, listingLimit, onFetchSuccess, showCreateDashboardButton, title, updateItemMeta, urlStateEnabled]);
  const refreshUnsavedDashboards = (0, _react.useCallback)(() => setUnsavedDashboardIds((0, _dashboard_backup_service.getDashboardBackupService)().getDashboardIdsWithUnsavedChanges()), []);
  const contentInsightsClient = (0, _react.useMemo)(() => new _contentManagementContentInsightsPublic.ContentInsightsClient({
    http: _kibana_services.coreServices.http,
    logger: _logger.logger
  }, {
    domainId: 'dashboard'
  }), []);
  return {
    hasInitialFetchReturned,
    pageDataTestSubject,
    refreshUnsavedDashboards,
    tableListViewTableProps,
    unsavedDashboardIds,
    contentInsightsClient
  };
};
exports.useDashboardListingTable = useDashboardListingTable;