"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeDataLoadingManager = initializeDataLoadingManager;
var _rxjs = require("rxjs");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _presentationContainers = require("@kbn/presentation-containers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function initializeDataLoadingManager(children$) {
  const dataLoading$ = new _rxjs.BehaviorSubject(undefined);
  const dataLoadingSubscription = (0, _presentationContainers.combineCompatibleChildrenApis)({
    children$
  }, 'dataLoading$', _presentationPublishing.apiPublishesDataLoading, undefined,
  // flatten method
  values => {
    return values.some(isLoading => isLoading);
  }).subscribe(isAtLeastOneChildLoading => {
    dataLoading$.next(isAtLeastOneChildLoading);
  });
  return {
    api: {
      dataLoading$
    },
    internalApi: {
      waitForPanelsToLoad$: dataLoading$.pipe(
      // debounce to give time for panels to start loading if they are going to load
      (0, _rxjs.debounceTime)(300), (0, _rxjs.first)(isLoading => {
        return !isLoading;
      }), (0, _rxjs.map)(() => {
        // Observable notifies subscriber when loading is finished
        // Return void to not expose internal implementation details of observable
        return;
      }))
    },
    cleanup: () => {
      dataLoadingSubscription.unsubscribe();
    }
  };
}