"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerInfoRoute = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerInfoRoute = router => {
  router.get({
    path: '/api/custom_branding/info',
    security: {
      authz: {
        enabled: false,
        reason: 'This route is opted out from authorization, because this route is rather a status check route than a data fetching route'
      }
    },
    validate: false,
    options: {
      authRequired: 'optional'
    }
  }, async (ctx, req, res) => {
    const allowed = isValidLicense((await ctx.licensing).license);
    if (!allowed) {
      return res.forbidden();
    }
    return res.ok({
      body: {
        allowed
      }
    });
  });
};
exports.registerInfoRoute = registerInfoRoute;
const isValidLicense = license => {
  return license.hasAtLeast('enterprise');
};