"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uiSettingsConfig = exports.defaultThemeSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _coreUiSettingsCommon = require("@kbn/core-ui-settings-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const deprecations = ({
  unused,
  renameFromRoot
}) => [unused('enabled', {
  level: 'warning'
}), renameFromRoot('server.defaultRoute', 'uiSettings.overrides.defaultRoute', {
  level: 'warning'
})];
const defaultThemeSchema = exports.defaultThemeSchema = _configSchema.schema.oneOf([
// TODO: Remove amsterdam theme
// https://github.com/elastic/eui-private/issues/170
_configSchema.schema.literal('amsterdam'), _configSchema.schema.literal('borealis'),
// Allow experimental themes
_configSchema.schema.string()]);
const configSchema = _configSchema.schema.object({
  overrides: _configSchema.schema.object({}, {
    unknowns: 'allow'
  }),
  publicApiEnabled: (0, _configSchema.offeringBasedSchema)({
    serverless: _configSchema.schema.boolean({
      defaultValue: false
    })
  }),
  experimental: _configSchema.schema.maybe(_configSchema.schema.object({
    themeSwitcherEnabled: _configSchema.schema.maybe(_configSchema.schema.boolean({
      defaultValue: false
    })),
    defaultTheme: _configSchema.schema.maybe(_configSchema.schema.string({
      defaultValue: _coreUiSettingsCommon.DEFAULT_THEME_NAME
    }))
  }))
});
const uiSettingsConfig = exports.uiSettingsConfig = {
  path: 'uiSettings',
  schema: configSchema,
  deprecations
};