"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createHiddenTypeVariants = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createHiddenTypeVariants = createOptions => {
  var _createOptions$hide, _createOptions$hideFr;
  return {
    name: createOptions.name,
    hidden: (_createOptions$hide = createOptions.hide) !== null && _createOptions$hide !== void 0 ? _createOptions$hide : false,
    hiddenFromHttpApis: (_createOptions$hideFr = createOptions.hideFromHttpApis) !== null && _createOptions$hideFr !== void 0 ? _createOptions$hideFr : undefined,
    namespaceType: createOptions.name === 'index-pattern' ? 'multiple' : 'single',
    mappings: {
      properties: {}
    }
  };
};
exports.createHiddenTypeVariants = createHiddenTypeVariants;