"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApiPrivileges = exports.ApiOperation = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
let ApiOperation = exports.ApiOperation = /*#__PURE__*/function (ApiOperation) {
  ApiOperation["Read"] = "read";
  ApiOperation["Create"] = "create";
  ApiOperation["Update"] = "update";
  ApiOperation["Delete"] = "delete";
  ApiOperation["Manage"] = "manage";
  return ApiOperation;
}({});
class ApiPrivileges {
  static manage(subject) {
    return `${ApiOperation.Manage}_${subject}`;
  }
  static read(subject) {
    return `${ApiOperation.Read}_${subject}`;
  }
  static create(subject) {
    return `${ApiOperation.Create}_${subject}`;
  }
  static update(subject) {
    return `${ApiOperation.Update}_${subject}`;
  }
  static delete(subject) {
    return `${ApiOperation.Delete}_${subject}`;
  }
}
exports.ApiPrivileges = ApiPrivileges;