"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PluginsService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _plugin = require("./plugin");
var _plugin_context = require("./plugin_context");
var _plugin_contract_resolver = require("./plugin_contract_resolver");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @internal */

/** @internal */

/** @internal */

/** @internal */

/**
 * Service responsible for loading plugin bundles, initializing plugins, and managing the lifecycle
 * of all plugins.
 *
 * @internal
 */
class PluginsService {
  constructor(coreContext, plugins) {
    (0, _defineProperty2.default)(this, "runtimeResolver", new _plugin_contract_resolver.RuntimePluginContractResolver());
    /** Plugin wrappers in topological order. */
    (0, _defineProperty2.default)(this, "plugins", new Map());
    (0, _defineProperty2.default)(this, "pluginDependencies", new Map());
    (0, _defineProperty2.default)(this, "satupPlugins", []);
    this.coreContext = coreContext;
    // Generate opaque ids
    const opaqueIds = new Map(plugins.map(p => [p.id, Symbol(p.id)]));

    // Setup dependency map and plugin wrappers
    plugins.forEach(({
      id,
      plugin,
      config = {}
    }) => {
      // Setup map of dependencies
      this.pluginDependencies.set(id, [...plugin.requiredPlugins, ...plugin.optionalPlugins.filter(optPlugin => opaqueIds.has(optPlugin))]);

      // Construct plugin wrappers, depending on the topological order set by the server.
      this.plugins.set(id, new _plugin.PluginWrapper(plugin, opaqueIds.get(id), (0, _plugin_context.createPluginInitializerContext)(this.coreContext, opaqueIds.get(id), plugin, config)));
    });
  }
  getOpaqueIds() {
    // Return dependency map of opaque ids
    return new Map([...this.pluginDependencies].map(([id, deps]) => [this.plugins.get(id).opaqueId, deps.map(depId => this.plugins.get(depId).opaqueId)]));
  }
  async setup(deps) {
    const runtimeDependencies = buildPluginRuntimeDependencyMap(this.plugins);
    this.runtimeResolver.setDependencyMap(runtimeDependencies);

    // Setup each plugin with required and optional plugin contracts
    const contracts = new Map();
    for (const [pluginName, plugin] of this.plugins.entries()) {
      const pluginDepContracts = [...this.pluginDependencies.get(pluginName)].reduce((depContracts, dependencyName) => {
        // Only set if present. Could be absent if plugin does not have client-side code or is a
        // missing optional plugin.
        if (contracts.has(dependencyName)) {
          depContracts[dependencyName] = contracts.get(dependencyName);
        }
        return depContracts;
      }, {});
      const contract = plugin.setup((0, _plugin_context.createPluginSetupContext)({
        deps,
        plugin,
        runtimeResolver: this.runtimeResolver
      }), pluginDepContracts);
      contracts.set(pluginName, contract);
      this.satupPlugins.push(pluginName);
    }
    this.runtimeResolver.resolveSetupRequests(contracts);

    // Expose setup contracts
    return {
      contracts
    };
  }
  async start(deps) {
    // Setup each plugin with required and optional plugin contracts
    const contracts = new Map();
    for (const [pluginName, plugin] of this.plugins.entries()) {
      const pluginDepContracts = [...this.pluginDependencies.get(pluginName)].reduce((depContracts, dependencyName) => {
        // Only set if present. Could be absent if plugin does not have client-side code or is a
        // missing optional plugin.
        if (contracts.has(dependencyName)) {
          depContracts[dependencyName] = contracts.get(dependencyName);
        }
        return depContracts;
      }, {});
      const contract = plugin.start((0, _plugin_context.createPluginStartContext)({
        deps,
        plugin,
        runtimeResolver: this.runtimeResolver
      }), pluginDepContracts);
      contracts.set(pluginName, contract);
    }
    this.runtimeResolver.resolveStartRequests(contracts);

    // Expose start contracts
    return {
      contracts
    };
  }
  async stop() {
    // Stop plugins in reverse topological order.
    for (const pluginName of this.satupPlugins.reverse()) {
      this.plugins.get(pluginName).stop();
    }
  }
}
exports.PluginsService = PluginsService;
const buildPluginRuntimeDependencyMap = pluginMap => {
  const runtimeDependencies = new Map();
  for (const [pluginName, pluginWrapper] of pluginMap.entries()) {
    const pluginRuntimeDeps = new Set([...pluginWrapper.optionalPlugins, ...pluginWrapper.requiredPlugins, ...pluginWrapper.runtimePluginDependencies]);
    runtimeDependencies.set(pluginName, pluginRuntimeDeps);
  }
  return runtimeDependencies;
};