"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFileInfo = exports.deleteFiles = void 0;
var _promises = require("fs/promises");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const deleteFiles = async ({
  filesToDelete
}) => {
  await Promise.all(filesToDelete.map(fileToDelete => (0, _promises.unlink)(fileToDelete)));
};
exports.deleteFiles = deleteFiles;
const getFileInfo = async absFilePath => {
  try {
    const {
      size,
      mtime
    } = await (0, _promises.stat)(absFilePath);
    return {
      exist: true,
      size,
      mtime
    };
  } catch (e) {
    if (e.code === 'ENOENT') {
      return {
        exist: false
      };
    }
    throw e;
  }
};
exports.getFileInfo = getFileInfo;