"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoadingCountService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @public */

/**
 * See {@link LoadingCountSetup}.
 * @public
 */

/** @internal */
class LoadingCountService {
  constructor() {
    (0, _defineProperty2.default)(this, "stop$", new _rxjs.Subject());
    (0, _defineProperty2.default)(this, "loadingCount$", new _rxjs.BehaviorSubject(0));
  }
  setup({
    fatalErrors
  }) {
    return {
      getLoadingCount$: () => this.loadingCount$.pipe((0, _rxjs.distinctUntilChanged)()),
      addLoadingCountSource: count$ => {
        count$.pipe((0, _rxjs.distinctUntilChanged)(), (0, _rxjs.tap)(count => {
          if (count < 0) {
            throw new Error('Observables passed to loadingCount.add() must only emit positive numbers');
          }
        }),
        // use takeUntil() so that we can finish each stream on stop() the same way we do when they complete,
        // by removing the previous count from the total
        (0, _rxjs.takeUntil)(this.stop$), (0, _rxjs.endWith)(0), (0, _rxjs.startWith)(0), (0, _rxjs.pairwise)(), (0, _rxjs.map)(([prev, next]) => next - prev)).subscribe({
          next: delta => {
            this.loadingCount$.next(this.loadingCount$.getValue() + delta);
          },
          error: error => fatalErrors.add(error)
        });
      }
    };
  }
  start({
    fatalErrors
  }) {
    return this.setup({
      fatalErrors
    });
  }
  stop() {
    this.stop$.next();
    this.loadingCount$.complete();
  }
}
exports.LoadingCountService = LoadingCountService;