"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocLinksService = void 0;
var _docLinks = require("@kbn/doc-links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @internal */

/** @internal */
class DocLinksService {
  constructor(coreContext) {
    this.coreContext = coreContext;
  }
  setup() {}
  start({
    injectedMetadata
  }) {
    const kibanaBranch = injectedMetadata.getKibanaBranch();
    const buildFlavor = this.coreContext.env.packageInfo.buildFlavor;
    const docMeta = (0, _docLinks.getDocLinksMeta)({
      kibanaBranch,
      buildFlavor
    });
    const docLinks = (0, _docLinks.getDocLinks)({
      kibanaBranch,
      buildFlavor
    });
    return {
      DOC_LINK_VERSION: docMeta.version,
      ELASTIC_WEBSITE_URL: docMeta.elasticWebsiteUrl,
      links: docLinks
    };
  }
}
exports.DocLinksService = DocLinksService;