"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.trapFocus = void 0;
var _get_focusable_elements = require("./get_focusable_elements");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Utility function for focus trap functionality.
 *
 * @param ref - The ref to the container element.
 */
const trapFocus = ref => e => {
  if (!ref.current || e.key !== 'Tab') return;
  const elements = (0, _get_focusable_elements.getFocusableElements)(ref.current);
  if (!ref.current.contains(document.activeElement)) return;
  if (!elements.length) return;
  const first = elements[0];
  const last = elements[elements.length - 1];
  const active = document.activeElement;
  if (e.shiftKey && active === first) {
    last.focus();
  } else if (!e.shiftKey && active === last) {
    first.focus();
  }
};
exports.trapFocus = trapFocus;