"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Navigation = void 0;
var _react = _interopRequireWildcard(require("react"));
var _coreChromeNavigation = require("@kbn/core-chrome-navigation");
var _rxjs = require("rxjs");
var _classnames = _interopRequireDefault(require("classnames"));
var _coreChromeNavigationTour = require("@kbn/core-chrome-navigation-tour");
var _sharedUxErrorBoundary = require("@kbn/shared-ux-error-boundary");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _redirect_app_links = require("./redirect_app_links");
var _to_navigation_items = require("./to_navigation_items");
var _panel_state_manager = require("./panel_state_manager");
var _navigation_feedback_snippet = require("./navigation_feedback_snippet");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/browser-internal/src/ui/project/sidenav_v2/navigation/navigation.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Navigation = props => {
  var _props$dataTestSubj$, _props$feedbackUrlPar;
  const state = useNavigationItems(props);
  const dataTestSubj = (0, _useObservable.default)((_props$dataTestSubj$ = props.dataTestSubj$) !== null && _props$dataTestSubj$ !== void 0 ? _props$dataTestSubj$ : _rxjs.EMPTY, undefined);
  const feedbackUrlParams = (0, _useObservable.default)((_props$feedbackUrlPar = props.feedbackUrlParams$) !== null && _props$feedbackUrlPar !== void 0 ? _props$feedbackUrlPar : _rxjs.EMPTY, undefined);
  if (!state) {
    return null;
  }
  const {
    navItems,
    logoItem,
    activeItemId,
    solutionId
  } = state;
  return /*#__PURE__*/_react.default.createElement(_sharedUxErrorBoundary.KibanaSectionErrorBoundary, {
    sectionName: 'Navigation',
    maxRetries: 3,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_coreChromeNavigationTour.NavigationTour, {
    tourManager: props.navigationTourManager,
    key:
    // Force remount (and reset position) the tour when the nav is collapsed/expanded
    props.isCollapsed ? 'collapsed' : 'expanded',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_redirect_app_links.RedirectNavigationAppLinks, {
    application: props.application,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_coreChromeNavigation.Navigation, {
    items: navItems,
    logo: logoItem,
    sidePanelFooter: /*#__PURE__*/_react.default.createElement(_navigation_feedback_snippet.NavigationFeedbackSnippet, {
      solutionId: solutionId,
      feedbackUrlParams: feedbackUrlParams,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 13
      }
    }),
    isCollapsed: props.isCollapsed,
    setWidth: props.setWidth,
    activeItemId: activeItemId,
    "data-test-subj": (0, _classnames.default)(dataTestSubj, 'projectSideNav', 'projectSideNavV2'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 9
    }
  })));
};

// For the React.Lazy import to work correctly, we need to export the component as default
// eslint-disable-next-line import/no-default-export
exports.Navigation = Navigation;
var _default = exports.default = Navigation;
const useNavigationItems = props => {
  const state$ = (0, _react.useMemo)(() => (0, _rxjs.combineLatest)([props.navigationTree$, props.activeNodes$]), [props.navigationTree$, props.activeNodes$]);
  const state = (0, _useObservable.default)(state$);
  const basePath = props.basePath.get();
  const panelStateManager = (0, _react.useMemo)(() => new _panel_state_manager.PanelStateManager(basePath), [basePath]);
  const memoizedItems = (0, _react.useMemo)(() => {
    if (!state) return null;
    const [navigationTree, activeNodes] = state;
    return (0, _to_navigation_items.toNavigationItems)(navigationTree, activeNodes, panelStateManager);
  }, [state, panelStateManager]);
  return memoizedItems;
};