"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderBadge = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/browser-internal/src/ui/header/header_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class HeaderBadge extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "subscription", void 0);
    this.state = {
      badge: undefined
    };
  }
  componentDidMount() {
    this.subscribe();
  }
  componentDidUpdate(prevProps) {
    if (prevProps.badge$ === this.props.badge$) {
      return;
    }
    this.unsubscribe();
    this.subscribe();
  }
  componentWillUnmount() {
    this.unsubscribe();
  }
  render() {
    if (this.state.badge == null) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement("div", {
      css: ({
        euiTheme
      }) => ({
        alignSelf: 'center',
        marginLeft: euiTheme.size.base
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      "data-test-subj": "headerBadge",
      "data-test-badge-label": this.state.badge.text,
      tabIndex: 0,
      label: this.state.badge.text,
      tooltipContent: this.state.badge.tooltip,
      iconType: this.state.badge.iconType,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 9
      }
    }));
  }
  subscribe() {
    this.subscription = this.props.badge$.subscribe(badge => {
      this.setState({
        badge
      });
    });
  }
  unsubscribe() {
    if (this.subscription) {
      this.subscription.unsubscribe();
      this.subscription = undefined;
    }
  }
}
exports.HeaderBadge = HeaderBadge;