"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CoreAppsService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _status = require("./status");
var _errors = require("./errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class CoreAppsService {
  constructor(coreContext) {
    (0, _defineProperty2.default)(this, "stopHistoryListening", void 0);
    this.coreContext = coreContext;
  }
  setup({
    application,
    http,
    injectedMetadata,
    notifications
  }) {
    application.register(this.coreContext.coreId, {
      id: 'error',
      title: 'App Error',
      visibleIn: [],
      mount(params) {
        // Do not use an async import here in order to ensure that network failures
        // cannot prevent the error UI from displaying. This UI is tiny so an async
        // import here is probably not useful anyways.
        return (0, _errors.renderApp)(params, {
          basePath: http.basePath
        });
      }
    });
    if (injectedMetadata.getAnonymousStatusPage()) {
      http.anonymousPaths.register('/status');
    }
    application.register(this.coreContext.coreId, {
      id: 'status',
      title: 'Server Status',
      appRoute: '/status',
      chromeless: true,
      visibleIn: [],
      mount(params) {
        return (0, _status.renderApp)(params, {
          http,
          notifications
        });
      }
    });
  }
  start({
    application,
    docLinks,
    http,
    notifications,
    uiSettings,
    ...startDeps
  }) {
    if (!application.history) {
      return;
    }
    this.stopHistoryListening = (0, _errors.setupUrlOverflowDetection)({
      basePath: http.basePath,
      history: application.history,
      toasts: notifications.toasts,
      uiSettings
    });
    (0, _errors.setupPublicBaseUrlConfigWarning)({
      docLinks,
      http,
      notifications,
      ...startDeps
    });
  }
  stop() {
    if (this.stopHistoryListening) {
      this.stopHistoryListening();
      this.stopHistoryListening = undefined;
    }
  }
}
exports.CoreAppsService = CoreAppsService;