"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CoreSecurityRouteHandlerContext = void 0;
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
var _authc = /*#__PURE__*/new WeakMap();
var _audit = /*#__PURE__*/new WeakMap();
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class CoreSecurityRouteHandlerContext {
  constructor(securityStart, request) {
    _classPrivateFieldInitSpec(this, _authc, void 0);
    _classPrivateFieldInitSpec(this, _audit, void 0);
    this.securityStart = securityStart;
    this.request = request;
  }
  get authc() {
    if (_classPrivateFieldGet(_authc, this) == null) {
      _classPrivateFieldSet(_authc, this, {
        getCurrentUser: () => this.securityStart.authc.getCurrentUser(this.request),
        apiKeys: {
          areAPIKeysEnabled: () => this.securityStart.authc.apiKeys.areAPIKeysEnabled(),
          create: createParams => this.securityStart.authc.apiKeys.create(this.request, createParams),
          update: updateParams => this.securityStart.authc.apiKeys.update(this.request, updateParams),
          validate: apiKeyParams => this.securityStart.authc.apiKeys.validate(apiKeyParams),
          invalidate: apiKeyParams => this.securityStart.authc.apiKeys.invalidate(this.request, apiKeyParams)
        }
      });
    }
    return _classPrivateFieldGet(_authc, this);
  }
  get audit() {
    if (_classPrivateFieldGet(_audit, this) == null) {
      _classPrivateFieldSet(_audit, this, {
        logger: this.securityStart.audit.asScoped(this.request)
      });
    }
    return _classPrivateFieldGet(_audit, this);
  }
}
exports.CoreSecurityRouteHandlerContext = CoreSecurityRouteHandlerContext;