"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BaseLogger = void 0;
var _elasticApmNode = _interopRequireDefault(require("elastic-apm-node"));
var _coreLoggingCommonInternal = require("@kbn/core-logging-common-internal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function isError(x) {
  return x instanceof Error;
}

/** @internal */
class BaseLogger extends _coreLoggingCommonInternal.AbstractLogger {
  createLogRecord(level, errorOrMessage, meta) {
    if (isError(errorOrMessage)) {
      return {
        context: this.context,
        error: errorOrMessage,
        level,
        message: errorOrMessage.message,
        meta,
        timestamp: new Date(),
        pid: process.pid,
        ...this.getTraceIds()
      };
    }
    return {
      context: this.context,
      level,
      message: errorOrMessage,
      meta,
      timestamp: new Date(),
      pid: process.pid,
      ...this.getTraceIds()
    };
  }
  getTraceIds() {
    return {
      spanId: _elasticApmNode.default.currentTraceIds['span.id'],
      traceId: _elasticApmNode.default.currentTraceIds['trace.id'],
      transactionId: _elasticApmNode.default.currentTraceIds['transaction.id']
    };
  }
}
exports.BaseLogger = BaseLogger;