"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isCompressed = isCompressed;
var _presentationPublishing = require("@kbn/presentation-publishing");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const apiHasCompressed = unknownApi => {
  return Boolean(unknownApi) && typeof unknownApi.compressed === 'boolean';
};
function isCompressed(api) {
  if (apiHasCompressed(api)) return api.compressed;
  return (0, _presentationPublishing.apiHasParentApi)(api) ? isCompressed(api.parentApi) : true;
}