"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOrphanedJobsCountQuery = exports.getIncompleteCountQuery = exports.getInProgressJobsCountQuery = exports.getIdleJobsCountQuery = exports.getErrorCountQuery = exports.getConnectedCountQuery = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _searchConnectors = require("@kbn/search-connectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getOrphanedJobsCountQuery = (ids, isCrawler) => {
  if (isCrawler === undefined) {
    return {
      bool: {
        must_not: [{
          terms: {
            'connector.id': ids
          }
        }]
      }
    };
  }
  if (isCrawler) {
    return {
      bool: {
        must: [{
          term: {
            'connector.service_type': _searchConnectors.CRAWLER_SERVICE_TYPE
          }
        }],
        must_not: [{
          terms: {
            'connector.id': ids
          }
        }]
      }
    };
  }
  return {
    bool: {
      must_not: [{
        terms: {
          'connector.id': ids
        }
      }, {
        term: {
          'connector.service_type': _searchConnectors.CRAWLER_SERVICE_TYPE
        }
      }]
    }
  };
};
exports.getOrphanedJobsCountQuery = getOrphanedJobsCountQuery;
const getInProgressJobsCountQuery = isCrawler => {
  if (isCrawler === undefined) {
    return {
      bool: {
        must: [{
          term: {
            status: _searchConnectors.SyncStatus.IN_PROGRESS
          }
        }]
      }
    };
  }
  if (isCrawler) {
    return {
      bool: {
        must: [{
          term: {
            status: _searchConnectors.SyncStatus.IN_PROGRESS
          }
        }],
        filter: [{
          bool: {
            must: {
              term: {
                'connector.service_type': _searchConnectors.CRAWLER_SERVICE_TYPE
              }
            }
          }
        }]
      }
    };
  }
  return {
    bool: {
      must: [{
        term: {
          status: _searchConnectors.SyncStatus.IN_PROGRESS
        }
      }],
      filter: [{
        bool: {
          must_not: {
            term: {
              'connector.service_type': _searchConnectors.CRAWLER_SERVICE_TYPE
            }
          }
        }
      }]
    }
  };
};
exports.getInProgressJobsCountQuery = getInProgressJobsCountQuery;
const getIdleJobsCountQuery = () => {
  return {
    bool: {
      filter: [{
        term: {
          status: _searchConnectors.SyncStatus.IN_PROGRESS
        }
      }, {
        bool: {
          must_not: {
            term: {
              'connector.service_type': _searchConnectors.CRAWLER_SERVICE_TYPE
            }
          }
        }
      }, {
        range: {
          last_seen: {
            lt: (0, _moment.default)().subtract(5, 'minute').toISOString()
          }
        }
      }]
    }
  };
};
exports.getIdleJobsCountQuery = getIdleJobsCountQuery;
const getErrorCountQuery = isCrawler => {
  if (isCrawler === undefined) {
    return {
      bool: {
        must: [{
          term: {
            last_sync_status: _searchConnectors.SyncStatus.ERROR
          }
        }]
      }
    };
  }
  if (isCrawler) {
    return {
      bool: {
        must: [{
          term: {
            last_sync_status: _searchConnectors.SyncStatus.ERROR
          }
        }],
        filter: [{
          term: {
            service_type: _searchConnectors.CRAWLER_SERVICE_TYPE
          }
        }]
      }
    };
  }
  return {
    bool: {
      must: [{
        term: {
          last_sync_status: _searchConnectors.SyncStatus.ERROR
        }
      }],
      filter: [{
        bool: {
          must_not: {
            term: {
              service_type: _searchConnectors.CRAWLER_SERVICE_TYPE
            }
          }
        }
      }]
    }
  };
};
exports.getErrorCountQuery = getErrorCountQuery;
const getConnectedCountQuery = isCrawler => {
  if (isCrawler === undefined) {
    return {
      bool: {
        filter: [{
          term: {
            status: _searchConnectors.ConnectorStatus.CONNECTED
          }
        }, {
          range: {
            last_seen: {
              gte: (0, _moment.default)().subtract(30, 'minutes').toISOString()
            }
          }
        }]
      }
    };
  }
  if (isCrawler) {
    return {
      bool: {
        filter: [{
          term: {
            status: _searchConnectors.ConnectorStatus.CONNECTED
          }
        }, {
          term: {
            service_type: _searchConnectors.CRAWLER_SERVICE_TYPE
          }
        }]
      }
    };
  }
  return {
    bool: {
      filter: [{
        term: {
          status: _searchConnectors.ConnectorStatus.CONNECTED
        }
      }, {
        bool: {
          must_not: {
            term: {
              service_type: _searchConnectors.CRAWLER_SERVICE_TYPE
            }
          }
        }
      }, {
        range: {
          last_seen: {
            gte: (0, _moment.default)().subtract(30, 'minutes').toISOString()
          }
        }
      }]
    }
  };
};
exports.getConnectedCountQuery = getConnectedCountQuery;
const getIncompleteCountQuery = isCrawler => {
  if (isCrawler === undefined) {
    return {
      bool: {
        should: [{
          bool: {
            must_not: {
              terms: {
                status: [_searchConnectors.ConnectorStatus.CONNECTED, _searchConnectors.ConnectorStatus.ERROR]
              }
            }
          }
        }, {
          range: {
            last_seen: {
              lt: (0, _moment.default)().subtract(30, 'minutes').toISOString()
            }
          }
        }]
      }
    };
  }
  if (isCrawler) {
    return {
      bool: {
        must_not: [{
          terms: {
            status: [_searchConnectors.ConnectorStatus.CONNECTED, _searchConnectors.ConnectorStatus.ERROR]
          }
        }],
        filter: [{
          term: {
            service_type: _searchConnectors.CRAWLER_SERVICE_TYPE
          }
        }]
      }
    };
  }
  return {
    bool: {
      must_not: {
        terms: {
          status: [_searchConnectors.ConnectorStatus.CONNECTED, _searchConnectors.ConnectorStatus.ERROR]
        }
      },
      must: {
        range: {
          last_seen: {
            lt: (0, _moment.default)().subtract(30, 'minutes').toISOString()
          }
        }
      },
      filter: [{
        bool: {
          must_not: {
            term: {
              service_type: _searchConnectors.CRAWLER_SERVICE_TYPE
            }
          }
        }
      }]
    }
  };
};
exports.getIncompleteCountQuery = getIncompleteCountQuery;