"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.enterpriseSearchLoadingOverlay = exports.enterpriseSearchLoading = void 0;
var _react = require("@emotion/react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const enterpriseSearchLoading = euiTheme => (0, _react.css)({
  left: '50%',
  position: 'absolute',
  top: '50%',
  transform: 'translate(-50%)',
  zIndex: euiTheme.levels.menu
});
exports.enterpriseSearchLoading = enterpriseSearchLoading;
const enterpriseSearchLoadingOverlay = euiTheme => (0, _react.css)({
  backgroundColor: (0, _eui.transparentize)(euiTheme.colors.emptyShade, 0.25),
  bottom: 0,
  left: 0,
  position: 'absolute',
  right: 0,
  top: 0,
  zIndex: euiTheme.levels.maskBelowHeader
});
exports.enterpriseSearchLoadingOverlay = enterpriseSearchLoadingOverlay;