"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchAvailableIndices = exports.FetchAvailableIndicesAPILogic = void 0;
var _constants = require("../../../common/constants");
var _create_api_logic = require("../api_logic/create_api_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchAvailableIndices = async ({
  searchQuery,
  http
}) => {
  const route = '/internal/content_connectors/connectors/available_indices';
  const query = {
    search_query: searchQuery || null
  };
  const response = await (http === null || http === void 0 ? void 0 : http.get(route, {
    query
  }));
  return response;
};
exports.fetchAvailableIndices = fetchAvailableIndices;
const FetchAvailableIndicesAPILogic = exports.FetchAvailableIndicesAPILogic = (0, _create_api_logic.createApiLogic)(['content', 'fetch_available_indices_api_logic'], fetchAvailableIndices, {
  requestBreakpointMS: _constants.INPUT_THROTTLE_DELAY_MS
});