"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MaybeType = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _type = require("./type");
var _oas_meta_fields = require("../oas_meta_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class MaybeType extends _type.Type {
  constructor(type) {
    super(type.getSchema().optional().meta({
      [_oas_meta_fields.META_FIELD_X_OAS_OPTIONAL]: true
    }).default(() => undefined));
    (0, _defineProperty2.default)(this, "maybeType", void 0);
    this.maybeType = type;
  }
  extendsDeep(options) {
    return new MaybeType(this.maybeType.extendsDeep(options));
  }
}
exports.MaybeType = MaybeType;