"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOtherAssignmentColor = getOtherAssignmentColor;
exports.isCategoricalColorConfig = isCategoricalColorConfig;
exports.isGradientColorConfig = isGradientColorConfig;
var _default_color_mapping = require("./default_color_mapping");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function isCategoricalColorConfig(config) {
  return config.colorMode.type === 'categorical';
}
function isGradientColorConfig(config) {
  return config.colorMode.type === 'gradient';
}
function getOtherAssignmentColor(specialAssignments, assignments) {
  if (
  // prevents misconfigured color mapping from having a no assignment and a different other color.
  // loop is default and only configuration with no assignments.
  assignments.length === 0 ||
  // TODO: the specialAssignment[0] position is arbitrary, we should fix it better
  specialAssignments[_default_color_mapping.DEFAULT_OTHER_ASSIGNMENT_INDEX].color.type === 'loop') {
    return {
      isLoop: true
    };
  } else {
    return {
      isLoop: false,
      color: specialAssignments[_default_color_mapping.DEFAULT_OTHER_ASSIGNMENT_INDEX].color
    };
  }
}