"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConfigFromPalette = getConfigFromPalette;
var _palettes = require("@kbn/palettes");
var _shared_components = require("../../shared_components");
var _match = require("../../shared_components/color_mapping/components/assignment/match");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const singleColorGradientPalettes = new Set([_palettes.KbnPalette.Red, _palettes.KbnPalette.Green, _palettes.KbnPalette.Cool, _palettes.KbnPalette.Warm, _palettes.KbnPalette.Gray]);

/**
 * Returns color mapping config from a `KbnPalette`
 *
 * Converts gradients to their equivalent color mapping config
 */
function getConfigFromPalette(palettes, paletteId) {
  const palette = palettes.get(paletteId);
  if (palette.type === 'categorical') {
    return {
      ..._shared_components.DEFAULT_COLOR_MAPPING_CONFIG,
      paletteId
    };
  }
  const defaultPaletteColorMap = new Map(palettes.get(_palettes.KbnPalette.Default).colors().map((color, i) => [color.toLowerCase(), i]));
  const colors = palette.colors(3).reverse();
  const steps = colors.map((color, i) => {
    var _defaultPaletteColorM;
    const colorIndex = (_defaultPaletteColorM = defaultPaletteColorMap.get(color.toLowerCase())) !== null && _defaultPaletteColorM !== void 0 ? _defaultPaletteColorM : -1;
    if (colorIndex > 0) return colorIndex;
    if (singleColorGradientPalettes.has(palette.id) && i > 0) return null;
    return color;
  }).filter(_match.isNotNull).map(color => ({
    touched: false,
    ...(typeof color === 'number' ? {
      paletteId: _palettes.KbnPalette.Default,
      type: 'categorical',
      colorIndex: color
    } : {
      type: 'colorCode',
      colorCode: color
    })
  }));
  return {
    ..._shared_components.DEFAULT_COLOR_MAPPING_CONFIG,
    paletteId: _palettes.KbnPalette.Default,
    colorMode: {
      type: 'gradient',
      steps,
      sort: 'asc' // match original gradient palette direction
    }
  };
}