"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTopRisks = exports.RisksTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _compliance_score_bar = require("../../../components/compliance_score_bar");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/pages/compliance_dashboard/compliance_charts/risks_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getTopRisks = (groupedFindingsEvaluation, maxItems) => {
  const sorted = groupedFindingsEvaluation.slice().sort((first, second) => first.postureScore - second.postureScore);
  return sorted.slice(0, maxItems);
};
exports.getTopRisks = getTopRisks;
const RisksTable = ({
  data: cisSectionsEvaluations,
  maxItems,
  onCellClick,
  onViewAllClick,
  viewAllButtonTitle,
  compact
}) => {
  const columns = (0, _react.useMemo)(() => [{
    field: 'name',
    truncateText: true,
    name: compact ? '' : _i18n.i18n.translate('xpack.csp.dashboard.risksTable.cisSectionColumnLabel', {
      defaultMessage: 'CIS Section'
    }),
    render: name => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "grouped-findings-evaluation-link",
      onClick: () => onCellClick(name),
      className: "eui-textTruncate",
      color: "text",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 11
      }
    }, name)
  }, {
    field: 'postureScore',
    width: '115px',
    name: compact ? '' : _i18n.i18n.translate('xpack.csp.dashboard.risksTable.complianceColumnLabel', {
      defaultMessage: 'Compliance'
    }),
    render: (postureScore, data) => /*#__PURE__*/_react.default.createElement(_compliance_score_bar.ComplianceScoreBar, {
      totalPassed: data.totalPassed,
      totalFailed: data.totalFailed,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 11
      }
    })
  }], [compact, onCellClick]);
  const sortedByComplianceScore = getTopRisks(cisSectionsEvaluations, maxItems);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    justifyContent: "spaceBetween",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    className: "risk-table",
    css: compact ? (0, _react2.css)`
                  thead {
                    .euiTableCellContent {
                      padding: 0;
                    }
                  }
                  .euiTable .euiTableRow .euiTableRowCell {
                    border-top: none;
                  }
                ` : undefined,
    items: sortedByComplianceScore,
    columns: columns,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "view-all-failed-findings",
    onClick: onViewAllClick,
    iconType: "search",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  }, viewAllButtonTitle))));
};
exports.RisksTable = RisksTable;