"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.benchmarkResponseSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Optionally, re-export the entire set of types. Interfaces and types declared after this will override v1 declarations.

const benchmarkResponseSchema = () => _configSchema.schema.object({
  items: _configSchema.schema.arrayOf(_configSchema.schema.object({
    id: _configSchema.schema.oneOf([_configSchema.schema.literal('cis_k8s'), _configSchema.schema.literal('cis_azure'), _configSchema.schema.literal('cis_aws'), _configSchema.schema.literal('cis_eks'), _configSchema.schema.literal('cis_gcp')]),
    name: _configSchema.schema.string(),
    version: _configSchema.schema.string(),
    score: _configSchema.schema.object({
      postureScore: _configSchema.schema.number({
        defaultValue: 0,
        min: 0
      }),
      resourcesEvaluated: _configSchema.schema.number({
        defaultValue: 0,
        min: 0
      }),
      totalFailed: _configSchema.schema.number({
        defaultValue: 0,
        min: 0
      }),
      totalFindings: _configSchema.schema.number({
        defaultValue: 0,
        min: 0
      }),
      totalPassed: _configSchema.schema.number({
        defaultValue: 0,
        min: 0
      })
    }),
    evaluation: _configSchema.schema.number({
      defaultValue: 0,
      min: 0
    })
  }))
});
exports.benchmarkResponseSchema = benchmarkResponseSchema;