"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.wrapCleanupCallback = wrapCleanupCallback;
var _lodash = require("lodash");
var _api = require("@opentelemetry/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DEFAULT_TIMEOUT = 5000;
function wrapCleanupCallback(cb, processExitSignal, options) {
  return (0, _lodash.once)(() => {
    return Promise.race([Promise.resolve().then(() => cb()), new Promise((_, reject) => {
      var _options$timeout;
      function rejectOnProcessExit() {
        reject(new Error(`Process exited before cleanup could finish`));
      }
      function rejectOnTimeout() {
        reject(new Error(`Timeout of ${timeout}ms reached before cleanup could finish`));
      }
      const timeout = (_options$timeout = options.timeout) !== null && _options$timeout !== void 0 ? _options$timeout : DEFAULT_TIMEOUT;
      if (!options.blockExit) {
        if (processExitSignal.aborted) {
          rejectOnProcessExit();
        } else {
          processExitSignal.addEventListener('abort', rejectOnProcessExit);
        }
      }
      setTimeout(rejectOnTimeout, timeout).unref();
    })]).catch(error => {
      _api.diag.warn(error);
    });
  });
}