"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteObservableRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../../../common/constants");
var _error = require("../../../common/error");
var _create_cases_route = require("../create_cases_route");
var _constants2 = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteObservableRoute = exports.deleteObservableRoute = (0, _create_cases_route.createCasesRoute)({
  method: 'delete',
  path: _constants.INTERNAL_CASE_OBSERVABLES_DELETE_URL,
  security: _constants2.DEFAULT_CASES_ROUTE_SECURITY,
  params: {
    params: _configSchema.schema.object({
      case_id: _configSchema.schema.string(),
      observable_id: _configSchema.schema.string()
    })
  },
  routerOptions: {
    access: 'internal',
    summary: `Delete a case observable`
  },
  handler: async ({
    context,
    request,
    response
  }) => {
    try {
      const caseContext = await context.cases;
      const casesClient = await caseContext.getCasesClient();
      const caseId = request.params.case_id;
      const observableId = request.params.observable_id;
      await casesClient.cases.deleteObservable(caseId, observableId);
      return response.noContent();
    } catch (error) {
      throw (0, _error.createCaseError)({
        message: `Failed to delete observable in route case id: ${request.params.case_id}, observable id: ${request.params.observable_id}: ${error}`,
        error
      });
    }
  }
});