"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInternalRoutes = void 0;
var _get_connectors = require("./internal/get_connectors");
var _get_case_user_actions_stats = require("./internal/get_case_user_actions_stats");
var _bulk_create_attachments = require("./internal/bulk_create_attachments");
var _bulk_get_cases = require("./internal/bulk_get_cases");
var _suggest_user_profiles = require("./internal/suggest_user_profiles");
var _bulk_get_attachments = require("./internal/bulk_get_attachments");
var _get_case_users = require("./internal/get_case_users");
var _bulk_delete_file_attachments = require("./internal/bulk_delete_file_attachments");
var _get_categories = require("./cases/categories/get_categories");
var _get_case_metrics = require("./internal/get_case_metrics");
var _get_cases_metrics = require("./internal/get_cases_metrics");
var _search_cases = require("./internal/search_cases");
var _replace_custom_field = require("./internal/replace_custom_field");
var _post_observable = require("./observables/post_observable");
var _bulk_post_observable = require("./observables/bulk_post_observable");
var _similar = require("./cases/similar");
var _patch_observable = require("./observables/patch_observable");
var _delete_observable = require("./observables/delete_observable");
var _find_user_actions = require("./internal/find_user_actions");
var _find_cases_containing_all_alerts = require("./internal/find_cases_containing_all_alerts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getInternalRoutes = userProfileService => [_bulk_create_attachments.bulkCreateAttachmentsRoute, (0, _suggest_user_profiles.suggestUserProfilesRoute)(userProfileService), _get_connectors.getConnectorsRoute, _bulk_get_cases.bulkGetCasesRoute, _get_case_user_actions_stats.getCaseUserActionStatsRoute, _bulk_get_attachments.bulkGetAttachmentsRoute, _get_case_users.getCaseUsersRoute, _bulk_delete_file_attachments.bulkDeleteFileAttachments, _get_categories.getCategoriesRoute, _get_case_metrics.getCaseMetricRoute, _get_cases_metrics.getCasesMetricRoute, _search_cases.searchCasesRoute, _replace_custom_field.replaceCustomFieldRoute, _post_observable.postObservableRoute, _bulk_post_observable.bulkPostObservableRoute, _patch_observable.patchObservableRoute, _delete_observable.deleteObservableRoute, _similar.similarCaseRoute, _find_user_actions.findUserActionsRoute, _find_cases_containing_all_alerts.findCasesContainingAllAlertsRoute];
exports.getInternalRoutes = getInternalRoutes;