"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.postCaseRoute = void 0;
var _constants = require("../../../../common/constants");
var _error = require("../../../common/error");
var _create_cases_route = require("../create_cases_route");
var _constants2 = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const postCaseRoute = exports.postCaseRoute = (0, _create_cases_route.createCasesRoute)({
  method: 'post',
  path: _constants.CASES_URL,
  security: _constants2.DEFAULT_CASES_ROUTE_SECURITY,
  routerOptions: {
    access: 'public',
    summary: `Create a case`,
    tags: ['oas-tag:cases']
  },
  handler: async ({
    context,
    request,
    response
  }) => {
    try {
      const caseContext = await context.cases;
      const casesClient = await caseContext.getCasesClient();
      const theCase = request.body;
      const res = await casesClient.cases.create({
        ...theCase
      });
      return response.ok({
        body: res
      });
    } catch (error) {
      throw (0, _error.createCaseError)({
        message: `Failed to post case in route: ${error}`,
        error
      });
    }
  }
});