"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getV3 = void 0;
var _i18n = require("@kbn/i18n");
var _saved_objects = require("@kbn/files-plugin/server/saved_objects");
var _server = require("@kbn/core/server");
var _constants = require("../../common/constants");
var _common = require("../../common");
var _constants2 = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * The order of appearance in the feature privilege page
 * under the management section. Cases should be under
 * the Actions and Connectors feature
 */

const FEATURE_ORDER = 3100;
const getV3 = () => {
  const capabilities = (0, _common.createUICapabilities)();
  const apiTags = (0, _common.getApiTags)(_constants.APP_ID);
  return {
    id: _constants.FEATURE_ID_V3,
    name: _i18n.i18n.translate('xpack.cases.features.casesFeatureName', {
      defaultMessage: 'Cases'
    }),
    category: _server.DEFAULT_APP_CATEGORIES.management,
    app: [],
    order: FEATURE_ORDER,
    management: {
      insightsAndAlerting: [_constants.APP_ID]
    },
    cases: [_constants.APP_ID],
    privileges: {
      all: {
        api: apiTags.all,
        cases: {
          create: [_constants.APP_ID],
          read: [_constants.APP_ID],
          update: [_constants.APP_ID],
          push: [_constants.APP_ID]
        },
        management: {
          insightsAndAlerting: [_constants.APP_ID]
        },
        savedObject: {
          all: [..._saved_objects.hiddenTypes],
          read: [..._saved_objects.hiddenTypes]
        },
        ui: capabilities.all
      },
      read: {
        api: apiTags.read,
        cases: {
          read: [_constants.APP_ID]
        },
        management: {
          insightsAndAlerting: [_constants.APP_ID]
        },
        savedObject: {
          all: [],
          read: [..._saved_objects.hiddenTypes]
        },
        ui: capabilities.read
      }
    },
    subFeatures: [{
      name: _i18n.i18n.translate('xpack.cases.features.deleteSubFeatureName', {
        defaultMessage: 'Delete'
      }),
      privilegeGroups: [{
        groupType: 'independent',
        privileges: [{
          api: apiTags.delete,
          id: _constants2.CASES_DELETE_SUB_PRIVILEGE_ID,
          name: _i18n.i18n.translate('xpack.cases.features.deleteSubFeatureDetails', {
            defaultMessage: 'Delete cases and comments'
          }),
          includeIn: 'all',
          savedObject: {
            all: [..._saved_objects.hiddenTypes],
            read: [..._saved_objects.hiddenTypes]
          },
          cases: {
            delete: [_constants.APP_ID]
          },
          ui: capabilities.delete
        }]
      }]
    }, {
      name: _i18n.i18n.translate('xpack.cases.features.casesSettingsSubFeatureName', {
        defaultMessage: 'Case settings'
      }),
      privilegeGroups: [{
        groupType: 'independent',
        privileges: [{
          id: _constants2.CASES_SETTINGS_SUB_PRIVILEGE_ID,
          name: _i18n.i18n.translate('xpack.cases.features.casesSettingsSubFeatureDetails', {
            defaultMessage: 'Edit case settings'
          }),
          includeIn: 'all',
          savedObject: {
            all: [..._saved_objects.hiddenTypes],
            read: [..._saved_objects.hiddenTypes]
          },
          cases: {
            settings: [_constants.APP_ID]
          },
          ui: capabilities.settings
        }]
      }]
    }, {
      name: _i18n.i18n.translate('xpack.cases.features.addCommentsSubFeatureName', {
        defaultMessage: 'Create comments & attachments'
      }),
      privilegeGroups: [{
        groupType: 'independent',
        privileges: [{
          api: apiTags.createComment,
          id: _constants2.CASES_CREATE_COMMENT_SUB_PRIVILEGE_ID,
          name: _i18n.i18n.translate('xpack.cases.features.addCommentsSubFeatureDetails', {
            defaultMessage: 'Add comments to cases'
          }),
          includeIn: 'all',
          savedObject: {
            all: [..._saved_objects.hiddenTypes],
            read: [..._saved_objects.hiddenTypes]
          },
          cases: {
            createComment: [_constants.APP_ID]
          },
          ui: capabilities.createComment
        }]
      }]
    }, {
      name: _i18n.i18n.translate('xpack.cases.features.reopenCaseSubFeatureName', {
        defaultMessage: 'Re-open'
      }),
      privilegeGroups: [{
        groupType: 'independent',
        privileges: [{
          id: _constants2.CASES_REOPEN_SUB_PRIVILEGE_ID,
          name: _i18n.i18n.translate('xpack.cases.features.reopenCaseSubFeatureDetails', {
            defaultMessage: 'Re-open closed cases'
          }),
          includeIn: 'all',
          savedObject: {
            all: [],
            read: []
          },
          cases: {
            reopenCase: [_constants.APP_ID]
          },
          ui: capabilities.reopenCase
        }]
      }]
    }, {
      name: _i18n.i18n.translate('xpack.cases.features.assignUsersSubFeatureName', {
        defaultMessage: 'Assign users'
      }),
      privilegeGroups: [{
        groupType: 'independent',
        privileges: [{
          id: _constants2.CASES_ASSIGN_SUB_PRIVILEGE_ID,
          name: _i18n.i18n.translate('xpack.cases.features.assignUsersSubFeatureName', {
            defaultMessage: 'Assign users to cases'
          }),
          includeIn: 'all',
          savedObject: {
            all: [],
            read: []
          },
          cases: {
            assign: [_constants.APP_ID]
          },
          ui: capabilities.assignCase
        }]
      }]
    }]
  };
};
exports.getV3 = getV3;