"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.throwBadRequestError = exports.decodeWithExcessOrThrow = exports.decodeOrThrow = exports.createPlainError = void 0;
var _boom = require("@hapi/boom");
var _Either = require("fp-ts/Either");
var _function = require("fp-ts/function");
var _pipeable = require("fp-ts/pipeable");
var _exact_check = require("@kbn/securitysolution-io-ts-utils/src/exact_check");
var _format_errors = require("@kbn/securitysolution-io-ts-utils/src/format_errors");
var _api = require("../../common/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createPlainError = message => new Error(message);
exports.createPlainError = createPlainError;
const throwBadRequestError = errors => {
  throw (0, _boom.badRequest)((0, _format_errors.formatErrors)(errors).join());
};

/**
 * This function will throw if a required field is missing or an excess field is present.
 * NOTE: This will only throw for an excess field if the type passed in leverages exact from io-ts.
 */
exports.throwBadRequestError = throwBadRequestError;
const decodeWithExcessOrThrow = runtimeType => inputValue => (0, _pipeable.pipe)(runtimeType.decode(inputValue), decoded => (0, _exact_check.exactCheck)(inputValue, decoded), (0, _Either.fold)(throwBadRequestError, _function.identity));

/**
 * This function will throw if a required field is missing.
 */
exports.decodeWithExcessOrThrow = decodeWithExcessOrThrow;
const decodeOrThrow = (runtimeType, createError = createPlainError) => inputValue => (0, _pipeable.pipe)(runtimeType.decode(inputValue), (0, _Either.fold)((0, _api.throwErrors)(createError), _function.identity));
exports.decodeOrThrow = decodeOrThrow;