"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDeleteFileAttachment = void 0;
var _reactQuery = require("@kbn/react-query");
var _constants = require("./constants");
var _use_on_refresh_case_view_page = require("../components/case_view/use_on_refresh_case_view_page");
var _use_cases_toast = require("../common/use_cases_toast");
var _api = require("./api");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDeleteFileAttachment = () => {
  const {
    showErrorToast,
    showSuccessToast
  } = (0, _use_cases_toast.useCasesToast)();
  const refreshAttachmentsTable = (0, _use_on_refresh_case_view_page.useRefreshCaseViewPage)();
  return (0, _reactQuery.useMutation)(({
    caseId,
    fileId
  }) => (0, _api.deleteFileAttachments)({
    caseId,
    fileIds: [fileId]
  }), {
    mutationKey: _constants.casesMutationsKeys.deleteFileAttachment,
    onSuccess: () => {
      showSuccessToast(i18n.FILE_DELETE_SUCCESS);
      refreshAttachmentsTable();
    },
    onError: error => {
      showErrorToast(error, {
        title: i18n.ERROR_DELETING_FILE
      });
    }
  });
};
exports.useDeleteFileAttachment = useDeleteFileAttachment;