"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetCaseConfiguration = void 0;
var _use_cases_context = require("../../components/cases_context/use_cases_context");
var _use_get_case_configurations_query = require("./use_get_case_configurations_query");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetCaseConfiguration = ({
  keepPreviousData
} = {}) => {
  const {
    owner
  } = (0, _use_cases_context.useCasesContext)();
  return (0, _use_get_case_configurations_query.useGetCaseConfigurationsQuery)({
    select: data => (0, _utils.getConfigurationByOwner)({
      configurations: data,
      owner: owner[0]
    }),
    keepPreviousData
  });
};
exports.useGetCaseConfiguration = useGetCaseConfiguration;