"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetAllCaseConfigurations = void 0;
var _utils = require("./utils");
var _use_get_case_configurations_query = require("./use_get_case_configurations_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformConfiguration = data => {
  if (data) {
    return data;
  }
  return [_utils.initialConfiguration];
};
const useGetAllCaseConfigurations = () => (0, _use_get_case_configurations_query.useGetCaseConfigurationsQuery)({
  select: transformConfiguration
});
exports.useGetAllCaseConfigurations = useGetAllCaseConfigurations;